/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/*
 * TmcdbTestConstants
 * 
 * Copyright European Southern Observatory 2008
 * 
 */
package alma.obops.dam.testutils;


/**
 * Constants values for TMCDB tests.
 * 
 * 
 * @author rkurowsk, Dec 15, 2007
 */



public class TmcdbTestConstants {

	public static final String CONFIG_NAME0 = "conf-0";
	public static final String CONFIG_NAME1 = "conf-1";
	public static final String CONFIG_NAME2 = "conf-2";
	public static final String CONFIG_DESC0 = "conf-0 description";
	public static final String CONFIG_LONGNAME0 = "conf-0 long";
	
	public static final String URN0 = "urn-0";
	public static final String URN1 = "urn-1";
	public static final String URN2 = "urn-2";

	public static final String IDL0 = "idl-0";
	public static final String IDL1 = "idl-1";
	public static final String IDL2 = "idl-2";
	
	public static final String BASE_ELEMENT_NAME0 = "base-el-0";
	public static final String BASE_ELEMENT_NAME1 = "base-el-1";
	public static final String BASE_ELEMENT_NAME2 = "base-el-2";

	public static final String PAD_NAME0 = "pad-0";
	public static final String PAD_NAME1 = "pad-1";
	public static final String PAD_NAME2 = "pad-2";

	public static final String COMPONENT_NAME0 = "comp-0";
	public static final String COMPONENT_NAME1 = "comp-1";
	public static final String COMPONENT_NAME2 = "comp-2";

	public static final String ANTENNA_NAME0 = "antenna-0";
	public static final String ANTENNA_NAME1 = "antenna-1";
	public static final String ANTENNA_NAME2 = "antenna-2";
	
	public static final String LRU_NAME_0 = "lru-00";
	public static final String LRU_NAME_1 = "lru-01";
	public static final String LRU_NAME_2 = "lru-02";
	
	public static final String LRU_FULLNAME = "lru-fullname";
	public static final String LRU_ICD 		= "lru-icd";
	public static final long   LRU_ICD_DATE = System.currentTimeMillis();
	public static final String LRU_DESC 	= "lru-description";
	public static final String LRU_NOTES 	= "lru-notes";

	public static final String ASSEMBLY_TYPE_NAME_0 = "ast-00";
	public static final String ASSEMBLY_TYPE_NAME_1 = "ast-01";
	public static final String ASSEMBLY_TYPE_NAME_2 = "ast-02";
	
	public static final String STARTUP_NAME_0 = "startup-00";
	public static final String STARTUP_NAME_1 = "startup-01";
	public static final String STARTUP_NAME_2 = "startup-02";

	public static final String ASSEMBLY_ROLE_NAME_0 = "asr-00";
	public static final String ASSEMBLY_ROLE_NAME_1 = "asr-01";
	public static final String ASSEMBLY_ROLE_NAME_2 = "asr-02";

	public static final String STARTUP_SCENARIO_NAME_0 = "startup-scenario-00";
	public static final String STARTUP_SCENARIO_NAME_1 = "startup-scenario-01";
	public static final String STARTUP_SCENARIO_NAME_2 = "startup-scenario-02";

}
