/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * TmcdbTestCase.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.dam.testutils;

import static alma.obops.dam.utils.SpringConstants.TEST_TMCDB_SPRING_CONFIG;

import java.io.File;
import java.sql.SQLException;

import alma.archive.database.helpers.wrappers.AbstractDbConfig;
import alma.obops.dam.tmcdb.dao.TmcdbDao;


/**
 * Superclass of all unit tests for the TMCDB
 *
 * @author amchavan, Sep 8, 2008
 * 
 */



public class TmcdbTestCase extends DamTestCase {
    
	protected TmcdbDao tmcdbDao;
	protected AbstractDbConfig dbConfig;
	private static final String pathPrefix = File.separator + "config" + File.separator + "DDL" + File.separator + "hsqldb" + File.separator;
	private static final String pathDropSuffix = File.separator + "DropAllTables.sql";
	private static final String pathCreateSuffix =  File.separator + "CreateHsqldbTables.sql";

	/**
	 * @param tmcdbDao the tmcdbDao to set
	 */
	public void setTmcdbDao(TmcdbDao tmcdbDao) {
		this.tmcdbDao = tmcdbDao;
	}

	public void setDbConfig(AbstractDbConfig dbConfig) {
		this.dbConfig = dbConfig;
	}

	/** 
     * Creates an empty TMCDB 
     * @throws RuntimeException
     * @throws SQLException 
     */
	protected void onSetUpInTransaction() throws Exception {

		super.onSetUpInTransaction();

		
		String acsdata = System.getenv("ACSDATA");
		assertNotNull("ACSDATA environment variable is not defined", acsdata);

    	String url = dbConfig.getConnectionUrl();
    	String fullyQualifiedPathToDropTablesScript = acsdata + pathPrefix + "TMCDB_hwconfigmonitoring" + pathDropSuffix;
    	
		// drop existing tables, if any.
        try {
        	if(url.contains(":oracle:"))
        	{
    			deleteAllTables(fullyQualifiedPathToDropTablesScript); 
    			fullyQualifiedPathToDropTablesScript = acsdata + pathPrefix + "TMCDB_swconfigext" + pathDropSuffix;
    			deleteAllTables(fullyQualifiedPathToDropTablesScript); 
    			fullyQualifiedPathToDropTablesScript = acsdata + pathPrefix + "TMCDB_swconfigcore" + pathDropSuffix;
    			deleteAllTables(fullyQualifiedPathToDropTablesScript); 	
    		} 
        	else 
        	{
    			dropAllTables(fullyQualifiedPathToDropTablesScript);	
    			fullyQualifiedPathToDropTablesScript = acsdata + pathPrefix + "TMCDB_swconfigext" + pathDropSuffix;
    			dropAllTables(fullyQualifiedPathToDropTablesScript);
    			fullyQualifiedPathToDropTablesScript = acsdata + pathPrefix + "TMCDB_swconfigcore" + pathDropSuffix;
    			dropAllTables(fullyQualifiedPathToDropTablesScript);
    		}
        }
        catch( Throwable e ) {
            // ignore -- sometimes there is nothing to delete
        	System.out.println("exception caught dropping tables; probably harmless (i.e. tables may have already been deleted)");
        }

		// create new tables
        // first the swconfig core
		String fullyQualifiedPathToCreateTablesScript = acsdata + pathPrefix + "TMCDB_swconfigcore" + pathCreateSuffix;
		createAllTAbles(fullyQualifiedPathToCreateTablesScript);
		
		// next the swconfig extended
		fullyQualifiedPathToCreateTablesScript = acsdata + pathPrefix + "TMCDB_swconfigext" + pathCreateSuffix;
		createAllTAbles(fullyQualifiedPathToCreateTablesScript);

		// finally the hwconfig
		fullyQualifiedPathToCreateTablesScript = acsdata + pathPrefix + "TMCDB_hwconfigmonitoring" + pathCreateSuffix;
		createAllTAbles(fullyQualifiedPathToCreateTablesScript);
		
		commitAndStartNewTransaction();
	}

    /**
     * Drops all contents from the TMCDB
     * @see alma.obops.dam.testutils.DamTestCase#tearDown()
     */
    @Override
    protected void onTearDownInTransaction() throws Exception {
    	
    	commitAndStartNewTransaction();
    	
		String acsdata = System.getenv("ACSDATA");
		assertNotNull(acsdata);

        try {
        	String url = dbConfig.getConnectionUrl();
        	if(url.contains(":oracle:"))
        	{
    			String fullyQualifiedPathToDropTablesScript = acsdata + pathPrefix + "TMCDB_hwconfigmonitoring" + pathDropSuffix;
    			deleteAllTables(fullyQualifiedPathToDropTablesScript); 
    		
    			fullyQualifiedPathToDropTablesScript = acsdata + pathPrefix + "TMCDB_swconfigext" + pathDropSuffix;
    			deleteAllTables(fullyQualifiedPathToDropTablesScript); 
    			
    			fullyQualifiedPathToDropTablesScript = acsdata + pathPrefix + "TMCDB_swconfigcore" + pathDropSuffix;
    			deleteAllTables(fullyQualifiedPathToDropTablesScript); 	
    		} 
        	else 
        	{
    			String fullyQualifiedPathToDropTablesScript = acsdata + pathPrefix + "TMCDB_hwconfigmonitoring" + pathDropSuffix;
    			dropAllTables(fullyQualifiedPathToDropTablesScript);
    			
    			fullyQualifiedPathToDropTablesScript = acsdata + pathPrefix + "TMCDB_swconfigext" + pathDropSuffix;
    			dropAllTables(fullyQualifiedPathToDropTablesScript);
    			
    			fullyQualifiedPathToDropTablesScript = acsdata + pathPrefix + "TMCDB_swconfigcore" + pathDropSuffix;
    			dropAllTables(fullyQualifiedPathToDropTablesScript);
    		}
        }
        catch( Exception e ) {
            // ignore -- sometimes there is nothing to delete
        }

        super.onTearDownInTransaction();
    }
    
	/* (non-Javadoc)
	 * @see alma.obops.dam.testutils.DamTestCase#getConfigLocations()
	 */
	protected String[] getConfigLocations() {
		return new String[] { TEST_TMCDB_SPRING_CONFIG};
	}
}
