/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * 
 */
package alma.obops.dam.config;

import static alma.obops.dam.utils.SpringConstants.ACACORRDELAYS_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.ACSSERVICE_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.ALARM_CATEGORY_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.ALARM_DEFINITION_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.ANTENNA_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.ANTENNA_TO_PAD_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.ASSEMBLYSTARTUP_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.ASSEMBLY_ROLE_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.ASSEMBLY_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.ASSEMBLY_TYPE_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.BACIPROPERTY_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.BASE_ELEMENT_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.BASE_ELEMENT_STARTUP_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.CHANNEL_MAPPING_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.COMPONENT_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.COMPONENT_TYPE_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.COMPUTER_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.CONFIGURATION_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.CONTACT_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.CONTAINERSTARTUPOPTION_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.CONTAINER_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.CONVERSATION_INTERCEPTOR_BEAN;
import static alma.obops.dam.utils.SpringConstants.DEFAULTMEMBER_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.DEFAULT_CAN_ADDRESS_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.DOMAINS_MAPPING_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.EVENT_CHANNEL_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.FAULT_CODE_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.FAULT_FAMILY_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.FAULT_MEMBER_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.FOCUS_MODEL_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.FRONTEND_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.HIBERNATE_UTILS_BEAN;
import static alma.obops.dam.utils.SpringConstants.HOLOGRAPHY_TOWER_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.HOLOGRAPHY_TOWER_TO_PAD_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.HWSCHEMA_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.LOCATION_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.LRU_TYPE_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.MANAGER_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.NOTIFICATIONSERVICEMAPPING_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.PAD_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.POINTING_MODEL_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.REDUCTION_LINK_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.REDUCTION_THRESHOLD_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.SCHEMAS_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.STARTUPSCENARIO_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.SWCONFIGURATION_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.WEATHERSTATION_SERVICE_BEAN;
import static alma.obops.dam.utils.SpringConstants.XPDELAY_SERVICE_BEAN;
import alma.obops.dam.tmcdb.service.AcaCorrDelaysService;
import alma.obops.dam.tmcdb.service.AcsServiceService;
import alma.obops.dam.tmcdb.service.AlarmCategoryService;
import alma.obops.dam.tmcdb.service.AlarmDefinitionService;
import alma.obops.dam.tmcdb.service.AntennaService;
import alma.obops.dam.tmcdb.service.AntennaToPadService;
import alma.obops.dam.tmcdb.service.AssemblyRoleService;
import alma.obops.dam.tmcdb.service.AssemblyService;
import alma.obops.dam.tmcdb.service.AssemblyStartupService;
import alma.obops.dam.tmcdb.service.AssemblyTypeService;
import alma.obops.dam.tmcdb.service.BACIPropertyService;
import alma.obops.dam.tmcdb.service.BaseElementService;
import alma.obops.dam.tmcdb.service.BaseElementStartupService;
import alma.obops.dam.tmcdb.service.ChannelMappingService;
import alma.obops.dam.tmcdb.service.ComponentService;
import alma.obops.dam.tmcdb.service.ComponentTypeService;
import alma.obops.dam.tmcdb.service.ComputerService;
import alma.obops.dam.tmcdb.service.ConfigurationService;
import alma.obops.dam.tmcdb.service.ContactService;
import alma.obops.dam.tmcdb.service.ContainerService;
import alma.obops.dam.tmcdb.service.ContainerStartupOptionService;
import alma.obops.dam.tmcdb.service.DefaultCanAddressService;
import alma.obops.dam.tmcdb.service.DefaultMemberService;
import alma.obops.dam.tmcdb.service.DomainsMappingService;
import alma.obops.dam.tmcdb.service.EventChannelService;
import alma.obops.dam.tmcdb.service.FaultCodeService;
import alma.obops.dam.tmcdb.service.FaultFamilyService;
import alma.obops.dam.tmcdb.service.FaultMemberService;
import alma.obops.dam.tmcdb.service.FocusModelService;
import alma.obops.dam.tmcdb.service.FrontEndService;
import alma.obops.dam.tmcdb.service.HolographyTowerService;
import alma.obops.dam.tmcdb.service.HolographyTowerToPadService;
import alma.obops.dam.tmcdb.service.HwSchemaService;
import alma.obops.dam.tmcdb.service.LocationService;
import alma.obops.dam.tmcdb.service.LruTypeService;
import alma.obops.dam.tmcdb.service.ManagerService;
import alma.obops.dam.tmcdb.service.NotificationServiceMappingService;
import alma.obops.dam.tmcdb.service.PadService;
import alma.obops.dam.tmcdb.service.PointingModelService;
import alma.obops.dam.tmcdb.service.ReductionLinkService;
import alma.obops.dam.tmcdb.service.ReductionThresholdService;
import alma.obops.dam.tmcdb.service.SchemasService;
import alma.obops.dam.tmcdb.service.StartupScenarioService;
import alma.obops.dam.tmcdb.service.SwConfigurationService;
import alma.obops.dam.tmcdb.service.WeatherStationControllerService;
import alma.obops.dam.tmcdb.service.XpDelayService;
import alma.obops.dam.utils.ConversationInterceptor;
import alma.obops.dam.utils.HibernateUtils;
import alma.obops.utils.config.AbstractContextFactory;

/**
 * 
 * TmcdbContextFactory
 * 
 * This singleton class is responsible for creating a Spring Application 
 * context for the TMCDB API and configuring its Data Base settings using DbConfig.
 * 
 * @author rkurowsk, Nov 2, 2008
 * 
 */


public class TmcdbContextFactory extends AbstractContextFactory {

	/*
	 * The singleton INSTANCE.
	 */
	public static TmcdbContextFactory INSTANCE = new TmcdbContextFactory();
	
	/*
	 * private constructor to enforce Singleton
	 */
	private TmcdbContextFactory(){
	}

	/**
	 * Gets conversationInterceptor bean from spring
	 * @return
	 */
	public ConversationInterceptor getConversationInterceptor(){
		return (ConversationInterceptor)getBean(CONVERSATION_INTERCEPTOR_BEAN);
	}
	
	/**
	 * Gets a AssemblyRoleService bean from spring 
	 * @return
	 */
	public AssemblyRoleService getAssemblyRoleService() {
		return (AssemblyRoleService) getBean(ASSEMBLY_ROLE_SERVICE_BEAN);
	}
	

	public BaseElementService getBaseElementService() 
	{
		return (BaseElementService) getBean(BASE_ELEMENT_SERVICE_BEAN);
	}
	
	/**
	 * Gets a SchemasService bean from spring 
	 * @return
	 */
	public SchemasService getSchemasService() {
		return (SchemasService) getBean(SCHEMAS_SERVICE_BEAN);
	}

    /**
	 * Gets a ConfigurationService bean from spring 
	 * @return
	 */
	public ConfigurationService getConfigurationService() {
		return (ConfigurationService) getBean(CONFIGURATION_SERVICE_BEAN);
	}

	/**
	 * Gets a ConfigurationService bean from spring 
	 * @return
	 */
	public ContactService getContactService() {
		return (ContactService) getBean(CONTACT_SERVICE_BEAN);
	}
	
    /**
	 * Gets a SwConfigurationService bean from spring 
	 * @return
	 */
	public SwConfigurationService getSwConfigurationService() {
		return (SwConfigurationService) getBean(SWCONFIGURATION_SERVICE_BEAN);
	}
	
	 /**
	 * Gets a AlarmDefinitionService bean from spring 
	 * @return
	 */
	public AlarmDefinitionService getAlarmDefinitionService() {
		return (AlarmDefinitionService) getBean(ALARM_DEFINITION_SERVICE_BEAN);
	}

	 /**
	 * Gets a AlarmCategoryService bean from spring 
	 * @return
	 */
	public AlarmCategoryService getAlarmCategoryService() {
		return (AlarmCategoryService) getBean(ALARM_CATEGORY_SERVICE_BEAN);
	}
	
	 /**
	 * Gets a ReductionLinkService bean from spring 
	 * @return
	 */
	public ReductionLinkService getReductionLinkService() {
		return (ReductionLinkService) getBean(REDUCTION_LINK_SERVICE_BEAN);
	}
	
	/**
	 * Gets a ReductionThresholdService bean from spring 
	 * @return
	 */
	public ReductionThresholdService getReductionThresholdService() {
		return (ReductionThresholdService) getBean(REDUCTION_THRESHOLD_SERVICE_BEAN);
	}
	
    /**
	 * Gets a ContainerService bean from spring 
	 * @return
	 */
	public ContainerService getContainerService() {
		return (ContainerService) getBean(CONTAINER_SERVICE_BEAN);
	}
	
	/**
	 * Gets a NotificationServiceMappingService bean from spring 
	 * @return
	 */
	public NotificationServiceMappingService getNotificationServiceMappingService() {
		return (NotificationServiceMappingService) getBean(NOTIFICATIONSERVICEMAPPING_SERVICE_BEAN);
	}
	
	/**
	 * Gets a AcsServiceService bean from spring 
	 * @return
	 */
	public AcsServiceService getAcsServiceService() {
		return (AcsServiceService) getBean(ACSSERVICE_SERVICE_BEAN);
	}

	/**
	 * @return
	 */
	public ManagerService getManagerService() {
		return (ManagerService) getBean(MANAGER_SERVICE_BEAN);
	}
	
	 /**
	 * Gets a ContainerStartupOptionService bean from spring 
	 * @return
	 */
	public ContainerStartupOptionService getContainerStartupOptionService() {
		return (ContainerStartupOptionService) getBean(CONTAINERSTARTUPOPTION_SERVICE_BEAN);
	}

    /**
	 * Gets a ComputerService bean from spring 
	 * @return
	 */
	public ComputerService getComputerService() {
		return (ComputerService) getBean(COMPUTER_SERVICE_BEAN);
	}

    /**
	 * Gets a ComponentService bean from spring 
	 * @return
	 */
	public ComponentService getComponentService() {
		return (ComponentService) getBean(COMPONENT_SERVICE_BEAN);
	}
	
	 /**
	 * Gets a XpDelayService bean from spring 
	 * @return
	 */
	public XpDelayService getXpDelayService() {
		return (XpDelayService) getBean(XPDELAY_SERVICE_BEAN);
	}
	
    /**
	 * Gets a BACIPropertyService bean from spring
	 * @return
	 */
	public BACIPropertyService getBACIPropertyService() {
		return (BACIPropertyService) getBean(BACIPROPERTY_SERVICE_BEAN);
	}

	/**
	 * Gets a FrontEndService bean from spring
	 * @return
	 */
	public FrontEndService getFrontEndService() {
		return (FrontEndService) getBean(FRONTEND_SERVICE_BEAN);
	}
	
	 /**
	 * Gets a LocationService bean from spring 
	 * @return
	 */
    public LocationService getLocationService() {
		return (LocationService) getBean(LOCATION_SERVICE_BEAN);
	}
	
    /**
	 * Gets a PadService bean from spring 
	 * @return
	 */
    public PadService getPadService() {
		return (PadService) getBean(PAD_SERVICE_BEAN);
	}
    
    /**
	 * Gets a StartupScenarioService bean from spring 
	 * @return
	 */
    public StartupScenarioService getStartupScenarioService() {
		return (StartupScenarioService) getBean(STARTUPSCENARIO_SERVICE_BEAN);
	}

    /**
	 * Gets a AntennaToPadService bean from spring 
	 * @return
	 */
    public AntennaToPadService getAntennaToPadService() {
		return (AntennaToPadService) getBean(ANTENNA_TO_PAD_SERVICE_BEAN);
	}
    
    /**
	 * Gets a PadService bean from spring 
	 * @return
	 */
    public BaseElementStartupService getBaseElementStartupService() {
		return (BaseElementStartupService) getBean(BASE_ELEMENT_STARTUP_SERVICE_BEAN);
	}

    /**
	 * Gets a AcaCorrDelaysService bean from spring 
	 */
	public AcaCorrDelaysService getAcaCorrDelaysService() {
		return (AcaCorrDelaysService) getBean(ACACORRDELAYS_SERVICE_BEAN);
	}

    /**
	 * Gets a AntennaService bean from spring 
	 * @return
	 */
    public AntennaService getAntennaService() {
		return (AntennaService) getBean(ANTENNA_SERVICE_BEAN);
	}
    
    /**
	 * Gets a AntennaService bean from spring 
	 * @return
	 */
    public AssemblyService getAssemblyService() {
		return (AssemblyService) getBean(ASSEMBLY_SERVICE_BEAN);
	}
    
    /**
	 * Gets a ComponentTypeService bean from spring 
	 * @return
	 */
    public ComponentTypeService getComponentTypeService() {
		return (ComponentTypeService) getBean(COMPONENT_TYPE_SERVICE_BEAN);
	}
    
	public EventChannelService getEventChannelService() {
		return (EventChannelService) getBean(EVENT_CHANNEL_SERVICE_BEAN);
	}
    
	public DomainsMappingService getDomainsMappingService() {
		return (DomainsMappingService) getBean(DOMAINS_MAPPING_SERVICE_BEAN);
	}
	
	public ChannelMappingService getChannelMappingService() {
		return (ChannelMappingService) getBean(CHANNEL_MAPPING_SERVICE_BEAN);
	}
    
    /**
	 * Gets a ComponentTypeService bean from spring 
	 * @return
	 */
    public AssemblyStartupService getAssemblyStartupService() {
		return (AssemblyStartupService) getBean(ASSEMBLYSTARTUP_SERVICE_BEAN);
	}
    
    /**
	 * Gets a LruTypeService bean from spring 
	 * @return
	 */
    public LruTypeService getLruTypeService() {
		return (LruTypeService) getBean(LRU_TYPE_SERVICE_BEAN);
	}
    
    /**
	 * Gets a HolographyTowerService bean from spring 
	 * @return
	 */
    public HolographyTowerService getHolographyTowerService() {
		return (HolographyTowerService) getBean(HOLOGRAPHY_TOWER_SERVICE_BEAN);
	}

    /**
	 * Gets a PointingModelService bean from spring 
	 * @return
	 */
    public PointingModelService getPointingModelService() {
		return (PointingModelService) getBean(POINTING_MODEL_SERVICE_BEAN);
	}
    
    /**
	 * Gets a FocusModelService bean from spring 
	 * @return
	 */
    public FocusModelService getFocusModelService() {
		return (FocusModelService) getBean(FOCUS_MODEL_SERVICE_BEAN);
	}
    
    /**
	 * Gets a AssemblyTypeService bean from spring 
	 * @return
	 */
    public AssemblyTypeService getAssemblyTypeService() {
		return (AssemblyTypeService) getBean(ASSEMBLY_TYPE_SERVICE_BEAN);
	}
    
    /**
	 * Gets a DefaultMemberService bean from spring 
	 * @return
	 */
	public DefaultMemberService getDefaultMemberService() {
		return (DefaultMemberService) getBean(DEFAULTMEMBER_SERVICE_BEAN);
	}
	
    /**
	 * Gets a FaultFamilyService bean from spring 
	 * @return
	 */
	public FaultFamilyService getFaultFamilyService() {
		return (FaultFamilyService) getBean(FAULT_FAMILY_SERVICE_BEAN);
	}
	
	 /**
	 * Gets a FaultCodeService bean from spring 
	 * @return
	 */
	public FaultCodeService getFaultCodeService() {
		return (FaultCodeService) getBean(FAULT_CODE_SERVICE_BEAN);
	}
	
	/**
	 * Gets a HolographyTowerToPadService bean from spring 
	 * @return
	 */
	public HolographyTowerToPadService getHolographyTowerToPadService() {
		return (HolographyTowerToPadService) getBean(HOLOGRAPHY_TOWER_TO_PAD_SERVICE_BEAN);
	}
	
	/**
	 * Gets a FaultMemberService bean from spring 
	 * @return
	 */
	public FaultMemberService getFaultMemberService() {
		return (FaultMemberService) getBean(FAULT_MEMBER_SERVICE_BEAN);
	}

	/**
	 * Gets a DefaultCanAddressService bean from spring
	 * @return
	 */
	public DefaultCanAddressService getDefaultCanAddressService() {
		return (DefaultCanAddressService) getBean(DEFAULT_CAN_ADDRESS_SERVICE_BEAN);
	}

	/**
	 * Gets a HwSchemaService bean from spring
	 * @return
	 */
	public HwSchemaService getHwSchemaService() {
		return (HwSchemaService) getBean(HWSCHEMA_SERVICE_BEAN);
	}

	/**
	 * Gets a HwSchemaService bean from spring
	 * @return
	 */
	public WeatherStationControllerService getWeatherStationControllerService() {
		return (WeatherStationControllerService) getBean(WEATHERSTATION_SERVICE_BEAN);
	}
	
    /**
     * returns instance of hibernateUtils bean
     * @return
     */
    public HibernateUtils getHibernateUtils(){
    	return (HibernateUtils)getBean(HIBERNATE_UTILS_BEAN);
    }
	
	  /**
	  * Should be called when the application terminates down to flush all data
	  * to disk, release the file locks, then shut down the database server.
	  * Meaningful only if we are connected to a HSQLDB server and the database
	  * is set to <i>file</i> mode; otherwise it does nothing.
	  */
	 public void shutdown() {
	     if( connectionIsFileBased() ) {
	         getHibernateUtils().runSql( "shutdown" );
	     }
	     //TODO: need to perform other shutdown here? e.g close sessionFactory etc.
	 }
}
