package alma.tmcdb.utils;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import junit.framework.TestCase;

import org.hibernate.Session;
import org.hibernate.Transaction;

import alma.acs.tmcdb.Component;
import alma.acs.tmcdb.ComponentType;
import alma.acs.tmcdb.Configuration;
import alma.tmcdb.cloning.CloningTestUtils;
import alma.acs.tmcdb.AssemblyType;
import alma.acs.tmcdb.BEType;
import alma.acs.tmcdb.HWConfiguration;
import alma.acs.tmcdb.LRUType;

public class ConfigurationLoaderTest extends TestCase {

    public ConfigurationLoaderTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        
        Session session = HibernateUtil.getSessionFactory().openSession();
        Transaction transaction = session.beginTransaction();
        
        LRUType lru =
        	new LRUType();
        lru.setLRUName("Test");
        lru.setFullName("Test");
        lru.setICD("ICD XXX");
        lru.setICDDate(0L);
        lru.setDescription("");
    	lru.setNotes("");
        Configuration c = new Configuration();
        c.setConfigurationName("");
        c.setFullName("");
        c.setDescription("");
        c.setCreationTime(new Date());
        c.setActive(true);
        HWConfiguration config =
            new HWConfiguration();
        config.setConfiguration(c);
        config.setTelescopeName("OSF");
        //c.setConfigurationId(config.getConfigurationId());
        ComponentType assCompType = new ComponentType();
        assCompType.setIDL("IDL:alma/Control/Test:1.0");

        session.save(assCompType);
        session.save(c);
        session.save(config);

        AssemblyType assemblyType =
            new AssemblyType();
        assemblyType.setAssemblyTypeName("Test");
        assemblyType.setFullName("Test");
        assemblyType.setBaseElementType(BEType.TELESCOPE);
        assemblyType.setDescription("");
        assemblyType.setNotes("");
        assemblyType.setLRUType(lru);
        assemblyType.setComponentType(assCompType);
        assemblyType.setProductionCode("code");
        assemblyType.setSimulatedCode("simCode");
        assemblyType.addAssemblyRoleToAssemblyRoles(DomainEntityFactory.createAssemblyRole("SecondLOBBpr0"));
        assemblyType.addAssemblyRoleToAssemblyRoles(DomainEntityFactory.createAssemblyRole("SecondLOBBpr1"));
        assemblyType.addAssemblyRoleToAssemblyRoles(DomainEntityFactory.createAssemblyRole("Mount"));
        assemblyType.addAssemblyRoleToAssemblyRoles(DomainEntityFactory.createAssemblyRole("LPR"));
        assemblyType.addAssemblyRoleToAssemblyRoles(DomainEntityFactory.createAssemblyRole("CRD"));
        assemblyType.addAssemblyRoleToAssemblyRoles(DomainEntityFactory.createAssemblyRole("GPS"));
        lru.addAssemblyTypeToAssemblyTypes(assemblyType);
        session.save(lru);

        Set<Component> components = new HashSet<Component>();
        ComponentType antCompType = new ComponentType();
        antCompType.setIDL("IDL:alma/Control/Antenna:1.0");
        session.save(antCompType);
        components.add(CloningTestUtils.createComponent("DV01", "CONTROL", antCompType,config.getConfiguration()));
        components.add(CloningTestUtils.createComponent("DA41", "CONTROL", antCompType,config.getConfiguration()));

        ComponentType lo2CompType = new ComponentType();
        lo2CompType.setIDL("IDL:alma/Control/SecondLO:1.0");
        session.save(lo2CompType);
        components.add(CloningTestUtils.createComponent("SecondLO", "CONTROL/DV01", lo2CompType,config.getConfiguration()));
        components.add(CloningTestUtils.createComponent("SecondLO", "CONTROL/DA41", lo2CompType,config.getConfiguration()));

        ComponentType mountCompType = new ComponentType();
        mountCompType.setIDL("IDL:alma/Control/Mount:1.0");
        session.save(mountCompType);
        components.add(CloningTestUtils.createComponent("Mount", "CONTROL/DV01", mountCompType,config.getConfiguration()));
        components.add(CloningTestUtils.createComponent("Mount", "CONTROL/DA41", mountCompType,config.getConfiguration()));

        ComponentType loCompType = new ComponentType();
        loCompType.setIDL("IDL:alma/Control/AOSTiming:1.0");
        session.save(loCompType);
        components.add(CloningTestUtils.createComponent("AOSTiming", "CONTROL", loCompType,config.getConfiguration()));

        ComponentType feCompType = new ComponentType();
        feCompType.setIDL("IDL:alma/Control/Camera:1.0");
        session.save(feCompType);        
        components.add(CloningTestUtils.createComponent("Camera", "CONTROL/DV01", feCompType,config.getConfiguration()));
        components.add(CloningTestUtils.createComponent("Camera", "CONTROL/DA41", feCompType,config.getConfiguration()));

        ComponentType lprCompType = new ComponentType();
        lprCompType.setIDL("IDL:alma/Control/LPR:1.0");
        session.save(lprCompType);        
        components.add(CloningTestUtils.createComponent("LPR", "CONTROL/DA41/", lprCompType,config.getConfiguration()));

        ComponentType crdCompType = new ComponentType();
        crdCompType.setIDL("IDL:alma/Control/CRD:1.0");
        session.save(crdCompType);        
        components.add(CloningTestUtils.createComponent("CRD", "CONTROL/AOSTiming", crdCompType,config.getConfiguration()));
        ComponentType gpsCompType = new ComponentType();
        gpsCompType.setIDL("IDL:alma/Control/GPS:1.0");
        session.save(gpsCompType);
        components.add(CloningTestUtils.createComponent("GPS", "CONTROL/AOSTiming", gpsCompType,config.getConfiguration()));

        config.getConfiguration().setComponents(components);
        session.save(config);
        session.flush();
        
        transaction.commit();
        session.close();
    }

	@Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
    
    public void testLoader() throws Exception {
        
        ConfigurationLoader loader = new ConfigurationLoader();
        try {
            loader.loadConfiguration(new FileReader("/home/jschwarz/MODULES/ICD_ASTRI/SharedCode/TMCDB/Utils/test/Configuration.xml"));
        } catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        
    }

}
