/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * "@(#) $Id: JavaToIdlTranslator.java,v 1.11 2011/05/02 08:42:40 rtobar Exp $"
 */
package alma.tmcdb.translation;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

//import alma.ReceiverBandMod.ReceiverBand;
//import alma.TMCDB.BandOffsets;
//import alma.TMCDB.IFProcConnectionState;
import alma.TMCDB.ModelTerm;
import astri.TMCDB_IDL.TelescopeIDL;
import astri.TMCDB_IDL.PadIDL;
import astri.asdmIDLTypes.IDLArrayTime;
import astri.asdmIDLTypes.IDLLength;
import alma.acs.tmcdb.Telescope;
//import alma.acs.tmcdb.FEDelay;
import alma.acs.tmcdb.FocusModel;
import alma.acs.tmcdb.FocusModelCoeff;
//import alma.acs.tmcdb.IFDelay;
//import alma.acs.tmcdb.LODelay;
import alma.acs.tmcdb.Pad;
import alma.acs.tmcdb.PointingModel;
import alma.acs.tmcdb.PointingModelCoeff;

/**
 * Translates TMCDB Persistence Java classes to its IDL representation.
 * 
 * @author rhiriart
 */
public class JavaToIdlTranslator {
  
    public static TelescopeIDL toIDL(Telescope telescope) {
        if (telescope == null)
            throw new NullPointerException("Telescope is null");
        TelescopeIDL antidl =
            new TelescopeIDL(0,
                           telescope.getTelescopeName(),
                           telescope.getTelescopeType().toString(),
                           new IDLLength(telescope.getDishDiameter()),
                           new IDLArrayTime(telescope.getCommissionDate()),
                           new IDLLength(telescope.getLatitude()),
                           new IDLLength(telescope.getLongitude()),
                           new IDLLength(telescope.getAltitude()),
                           0);
        return antidl;
    }
    
    public static PadIDL toIDL(Pad pad) {
        if (pad == null)
            throw new NullPointerException("Pad is null");
        PadIDL padidl = new PadIDL(0,
                                   pad.getPadName(),
                                   new IDLArrayTime(pad.getCommissionDate()),
                                   new IDLLength(pad.getXPosition()),
                                   new IDLLength(pad.getXPosition()),
                                   new IDLLength(pad.getXPosition()));

        return padidl;
    }
    
    public static alma.TMCDB.TelescopePointingModel toIDL(PointingModel pointingModel) {
        
        List<ModelTerm> idlTerms = new ArrayList<ModelTerm>();
//        Map<Short, List<ModelTerm>> idlBandOffsetMap = new HashMap<Short, List<ModelTerm>>();
//        
//        idlBandOffsetMap.put((short)1, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)2, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)3, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)4, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)5, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)6, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)7, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)8, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)9, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)10, new ArrayList<ModelTerm>());
        
        for (PointingModelCoeff coeff : pointingModel.getPointingModelCoeffs()) {
            //PointingModelCoeff coeff = pointingModel.getTerms().get(termName);
            ModelTerm idlTerm = new ModelTerm();
            idlTerm.name = coeff.getCoeffName();
            idlTerm.value = coeff.getCoeffValue();
            idlTerms.add(idlTerm);
        }
        
       
        alma.TMCDB.TelescopePointingModel idlPointingModel = new alma.TMCDB.TelescopePointingModel();
        idlPointingModel.base = idlTerms.toArray(new ModelTerm[0]);
        return idlPointingModel;
    }
    
    public static alma.TMCDB.TelescopeFocusModel toIDL(FocusModel focusModel) {
        
        List<ModelTerm> idlTerms = new ArrayList<ModelTerm>();
//        List<BandOffsets> idlAllBandOffsets = new ArrayList<BandOffsets>();
//        Map<Short, List<ModelTerm>> idlBandOffsetMap = new HashMap<Short, List<ModelTerm>>();
//        
//        idlBandOffsetMap.put((short)1, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)2, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)3, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)4, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)5, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)6, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)7, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)8, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)9, new ArrayList<ModelTerm>());
//        idlBandOffsetMap.put((short)10, new ArrayList<ModelTerm>());
        
        // Get all the coefficients, insert each <coeffName, coeff> into a Map
        Map<String, FocusModelCoeff> cmap = new HashMap<String, FocusModelCoeff>();
        for (FocusModelCoeff coeff: focusModel.getFocusModelCoeffs()) {
        	cmap.put(coeff.getCoeffName(),coeff);
        }
        
        for (String termName : cmap.keySet()) {
            FocusModelCoeff coeff = cmap.get(termName);
            ModelTerm idlTerm = new ModelTerm();
            idlTerm.name = termName;
            idlTerm.value = coeff.getCoeffValue();
            idlTerms.add(idlTerm);
//            for (ReceiverBand offsetBand : coeff.getOffsets().keySet()) {
//                double offsetValue = coeff.getOffsets().get(offsetBand);
//                ModelTerm idlOffsetTerm = new ModelTerm();
//                idlOffsetTerm.name = termName;
//                idlOffsetTerm.value = offsetValue;
//                idlBandOffsetMap.get(getBandFromString(offsetBand.toString())).add(idlOffsetTerm);
//            }
        }
        
//        for (short band : idlBandOffsetMap.keySet()) {
//            List<ModelTerm> idlOffsetTerms = idlBandOffsetMap.get(band);
//            if (idlOffsetTerms.size() > 0) {
//                BandOffsets idlBandOffsets = new BandOffsets();
//                idlBandOffsets.bandNumber = band;
//                idlBandOffsets.terms = idlOffsetTerms.toArray(new ModelTerm[0]);
//                idlAllBandOffsets.add(idlBandOffsets);
//            }
//        }
        
        alma.TMCDB.TelescopeFocusModel idlFocusModel = new alma.TMCDB.TelescopeFocusModel();
        idlFocusModel.base = idlTerms.toArray(new ModelTerm[0]);
//        idlFocusModel.offsets = idlAllBandOffsets.toArray(new BandOffsets[0]);
        return idlFocusModel;
    }
    

    
}
