#! /usr/bin/env python
#
# ALMA - Atacama Large Millimiter Array
# (c) Associated Universities Inc., 2009
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
#
#
#

from optparse import OptionParser
import commands
import sys
import os

if __name__ == "__main__":
    usage = "usage: ImportPointingModel -f INPUT_FILE -m MESSAGE [-c configuration]"
    parser = OptionParser(usage=usage)
    parser.add_option("-c", "--configuration", dest="tmcdb",
        help="TMCDB configuration to import the pointing model.", metavar="TMCDB")
    parser.add_option("-f", "--file", dest="filename",
        help="input XML file to change the pointing model.", metavar="INPUT_FILE")
    parser.add_option("-v", "--verbose", action="store_true", help="print debug information to console", dest="verbose")
    parser.add_option("-m", "--message", dest="comment",
        help="uid,  number of srcs,  other brief description of change (ie.  antenna integration: DVXX, weekly regression, antenna movement from XX to YY: DAXX.., pt offsets);You must surround your comments by quotes.", metavar="MESSAGE")

    (options, args) = parser.parse_args()

    if os.environ.has_key('LOCATION') is True:
        if os.environ['LOCATION'] == 'AOS2':
            options.tmcdb = 'CURRENT.AOS'


    if options.tmcdb is None:
        tmcdb = str(commands.getoutput("echo $TMCDB_CONFIGURATION_NAME"))
    else:
        tmcdb = str(options.tmcdb)

    if tmcdb is None or len(tmcdb) == 0:
      parser.error("provide a configuration (via -c option) or set TMCDB_CONFIGURATION_NAME environment variable.")
    if options.filename is None:
        parser.error("provide an input file.\n")
    if options.comment is None:
        parser.error("provide a brief description of the change.\n")
    else:
        comment = "[ImportPointingModel.py] " + str(options.comment)
        filename = str(options.filename)
        instruction = "ls -l " + filename
        if commands.getstatusoutput(instruction)[0] != 0:
            parser.error(filename + " file doesn't exist. \n")
        
    instruction = "acsStartJava -endorsed alma.tmcdb.utils.PointingModelImporter "
    pid = str(commands.getoutput("echo $$"))
    logfile = "importPointingModel-" + pid + ".log"
    instruction = instruction + tmcdb + " " + filename + " \"\\\"" + comment + "\\\"\"" + " &> " + logfile
    commands.getoutput(instruction)

    if options.verbose is not None:
        print commands.getoutput("cat " + logfile)

    print "From " + filename+ " file, change pointing models for " + tmcdb + " configuration.\n"
