#! /usr/bin/env python
#
# ALMA - Atacama Large Millimiter Array
# (c) Associated Universities Inc., 2009
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
#
#
#

from optparse import OptionParser
import commands
import sys
import os

if __name__ == "__main__":
    parser = OptionParser()
    parser.add_option("-c", "--configuration", dest="tmcdb",
        help="TMCDB configuration to export the pointing model from.", metavar="TMCDB")
    parser.add_option("-f", "--file", dest="filename",
        help="output XML file to store the pointing model.", metavar="FILE")
    parser.add_option("-a", "--antenna", dest="antenna",
        help="antenna to export the pointing model from.", metavar="ANTENNA")
    parser.add_option("-t", "--time", dest="time",
        help="export the pointing model as it existed at the given time.", metavar="TIME")
    parser.add_option("-v", "--version", dest="version",
        help="export the pointing model of given version; this option requires an antenna to be provided as well", metavar="VERSION")
    parser.add_option("-y", "--history", dest="history", action="store_true",
        help="export version history for each antenna")
    parser.add_option("-g", "--debug", dest="debug", action="store_true",
        help="adds clumsy ACS Java options to get Hibernate detailed logs")

    (options, args) = parser.parse_args()

    if os.environ.has_key('LOCATION') is True:
        if os.environ['LOCATION'] == 'AOS2':
            options.tmcdb = 'CURRENT.AOS'


    if options.tmcdb is None:
        tmcdb = str(commands.getoutput("echo $TMCDB_CONFIGURATION_NAME"))
    else:
        tmcdb = str(options.tmcdb)

    if tmcdb is None or len(tmcdb) == 0:
         print "configuration was not specified; nor is TMCDB_CONFIGURATION_NAME environment variable set"
         exit(-1)

    if options.filename is None:
        pid = str(commands.getoutput("echo $$"))
        filename = "ArrayConfiguration-" + pid + ".xml"
    else:
        filename = str(options.filename)
        filename = filename.rstrip(".xml") + ".xml"
        
    if options.antenna is None:
        message = "Array configuration for all antennas in configuration '" + tmcdb + "' saved in " + filename 
    else:
        antenna = options.antenna
        message = "Array configuration for antenna " + antenna + " from configuration '" + tmcdb + "' saved in " + filename 

    if options.time is None:
        time = None
    else:
        time = options.time

    if options.version is None:
        version = None
    else:
        version = options.version

    instruction = "acsStartJava -endorsed "
    if options.debug:
        instruction += "-DACS.log.minlevel.namedloggers='hibernateSQL=1,1:hibernate=4,4' "
    instruction += "alma.tmcdb.utils.ArrayConfigurationsExporter "
         

    if options.tmcdb is not None:
        instruction = instruction + " -c " + tmcdb
    if options.time is not None:
        instruction = instruction + " -t " + time
    if options.version is not None:
        instruction = instruction + " -v " + version
    if filename is not None:
        instruction = instruction + " -o " + filename
    if options.antenna is not None:
        instruction = instruction + " -a " + antenna
    if options.history:
        instruction = instruction + " -y "

    instruction += " >& exportArrayConfiguration.log"

    commands.getoutput(instruction)

    if os.path.exists(filename):
        print message
    else:
        print "FAILED: check exportArrayConfiguration.log file for details"
