#!/bin/bash

##############################################################################
# ALMA - Atacama Large Millimiter Array
# (c) European Southern Observatory, 2002
# Copyright by ESO (in the framework of the ALMA collaboration),
# All rights reserved
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston,
# MA 02111-1307  USA
#
# $Id: runDomainTests.sh,v 1.1 2011/08/09 15:47:34 rhiriart Exp $
#

# Documentation about the test goes here.
#
#

CLASSPATH=../lib/TMCDBPersistenceTest.jar:$CLASSPATH

declare TEST_CLASS=alma.tmcdb.AllTests
declare TEST_LOG=/dev/stdout
declare ACS_TMP=`pwd`/tmp

if test $# -ge 1; then
  TEST_LOG=$1
fi

if [ -e $ACS_TMP ]; then
  rm -rf $ACS_TMP &> /dev/null
fi
mkdir $ACS_TMP

acsStartJava -Darchive.configFile=./archiveConfig.properties -endorsed junit.textui.TestRunner "$TEST_CLASS" &> "$TEST_LOG"
RESULT=$?
exit "$RESULT"

# __oOo__
