package alma.tmcdb.cloning;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;

import org.exolab.castor.mapping.MappingException;
import org.hibernate.Session;
import org.hibernate.Transaction;

import alma.acs.tmcdb.BEType;
import alma.acs.tmcdb.BEStartupBEType;
import alma.acs.tmcdb.Component;
import alma.acs.tmcdb.ComponentType;
import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.Telescope;
import alma.acs.tmcdb.TelescopeToCamera;
import alma.acs.tmcdb.TelescopeToPad;
import alma.acs.tmcdb.TelescopeTypeEnum;
import alma.acs.tmcdb.AssemblyRole;
import alma.acs.tmcdb.AssemblyStartup;
import alma.acs.tmcdb.AssemblyType;
import alma.acs.tmcdb.BaseElementStartup;
import alma.acs.tmcdb.BEType;
import alma.tmcdb.utils.Coordinate;
import alma.acs.tmcdb.Camera;
import alma.acs.tmcdb.HWConfiguration;
import alma.acs.tmcdb.LRUType;
import alma.acs.tmcdb.Pad;
import alma.acs.tmcdb.Startup;
import alma.tmcdb.TmcdbTestCase;
import alma.tmcdb.utils.CompositeIdentifierInterceptor;
import alma.tmcdb.utils.DomainEntityFactory;
import alma.tmcdb.utils.HibernateUtil;

/**
 * Tests the cloning (and persisting) of a startup scenario within an existing configuration.
 * @author sharrington
 */
public class CloneAndPersistStartupScenarioTest extends TmcdbTestCase 
{
	/**
	 * Constructor
	 * @param name the name of the test
	 */
	public CloneAndPersistStartupScenarioTest(String name) {
		super(name);
	}
	
	/*
	public void testCloningStartupScenarioWithoutBeanlib() throws FileNotFoundException, IOException, MappingException
	{	
		StartupScenario startup = createStartupForCloning();
     
		// ----------------------------------------------------------------------------------------
		// now that we have a configuration persisted, let's test the cloning of a startup scenario
		// ----------------------------------------------------------------------------------------
        
		CompositeIdentifierInterceptor interceptor = new CompositeIdentifierInterceptor();
        Session session = HibernateUtil.getSessionFactory().openSession(interceptor);
        Transaction transaction = session.beginTransaction();
        
        StartupScenario clonedStartup = CloningUtils.cloneStartupScenario(startup, startup.getName());
        
		if(startup == clonedStartup) {
			fail();; // shouldn't happen; object identities == means it's the same object (no actual clone)!
		}
		CloningTestUtils.clearListOfProblems();
		CloningTestUtils.safeEquals(startup, clonedStartup);
		if(CloningTestUtils.getListOfProblems().length > 0) {
			System.out.println("Probs: ");
			for(String prob : CloningTestUtils.getListOfProblems()) {
				System.out.println(prob);
			}
		}
		assertEquals(0, CloningTestUtils.getListOfProblems().length);
		CloningTestUtils.clearListOfProblems();
		assertEquals(null, clonedStartup.getId());
		
		System.out.println("orig startup id: " + startup.getId() + " name: " + startup.getName() + " and config id: " + startup.getConfiguration().getId());
		System.out.println("cloned startup id: " + clonedStartup.getId() + " name: " + clonedStartup.getName() + " and config id: " + clonedStartup.getConfiguration().getId());
			
		// change the name to avoid uniqueness constraints on name
		clonedStartup.setName("Copy of: " + clonedStartup.getName());
		
		System.out.println("--------------------------------------");
		System.out.println("orig: " + startup);
		System.out.println("--------------------------------------");
		System.out.println("clone: " + clonedStartup);

		session.saveOrUpdate(startup.getConfiguration());
				
		transaction.commit();
		session.close();	
	}
	*/
	
	public void testCloningStartupScenarioWithBeanlib() throws FileNotFoundException, IOException, MappingException
	{	
		Startup startup = createStartupForCloning();
        
		// ----------------------------------------------------------------------------------------
		// now that we have a configuration persisted, let's test the cloning of a startup scenario
		// ----------------------------------------------------------------------------------------
        
		CompositeIdentifierInterceptor interceptor = new CompositeIdentifierInterceptor();
        Session session = HibernateUtil.getSessionFactory().openSession(interceptor);
        Transaction transaction = session.beginTransaction();
        
        Startup clonedStartup = CloningUtils.cloneStartupWithBeanlib(HibernateUtil.getSessionFactory(), startup, startup.getStartupName());
        
		if(startup == clonedStartup) {
			fail();; // shouldn't happen; object identities == means it's the same object (no actual clone)!
		}

		System.out.println("orig startup id: " + startup.getStartupId() + " name: " + startup.getStartupName() + " and config id: " + startup.getHWConfiguration().getConfigurationId());
		System.out.println("cloned startup id: " + clonedStartup.getStartupId() + " name: " + clonedStartup.getStartupName() + " and config id: " + clonedStartup.getHWConfiguration().getConfigurationId());
		System.out.println("--------------------------------------");
		System.out.println("orig: " + startup);
		System.out.println("--------------------------------------");
		System.out.println("clone: " + clonedStartup);

		CloningTestUtils.clearListOfProblems();
		CloningTestUtils.safeEquals(startup, clonedStartup);
		assertEquals(0, CloningTestUtils.getListOfProblems().length);
		CloningTestUtils.clearListOfProblems();
		assertEquals(null, clonedStartup.getStartupId());
		
		// change the name to avoid uniqueness constraints on name
		clonedStartup.setStartupName("Copy of: " + clonedStartup.getStartupName());
		
		session.saveOrUpdate(startup.getHWConfiguration());
				
		transaction.commit();
		session.close();	
	}

	private Startup createStartupForCloning()
	{
		Transaction tx = null;
        LRUType lru = null;
        HWConfiguration config = null;
        Startup startup = null;
        ComponentType compType = null;
        Telescope antenna = null;
        Pad pad = null;
        BaseElementStartup baseElementStartup = null;
        AssemblyRole assemblyRole = null;
        Camera frontEnd = null;
        Configuration swCfg = null;
        CompositeIdentifierInterceptor interceptor = new CompositeIdentifierInterceptor();
        Session session = HibernateUtil.getSessionFactory().openSession(interceptor);
        tx = session.beginTransaction();

        swCfg = new Configuration();
        swCfg.setConfigurationName("Test");
        swCfg.setFullName("");
        swCfg.setActive(true);
        swCfg.setCreationTime(new Date());
        swCfg.setDescription("");
        config = new HWConfiguration();
        config.setTelescopeName("OSF");
        config.setConfiguration(swCfg);
        session.save(swCfg);
        session.save(config);
        compType = new ComponentType();
        compType.setIDL("IDL:alma/Control/FOO:1.0");
        session.save(compType);

        lru = DomainEntityFactory.createLRUType("lru", "lru", "icd", 0L, "", "");
        AssemblyType assemblyType = DomainEntityFactory.createAssemblyType("test",
        		"test",
        		BEType.TELESCOPE,
        		"",
        		"",
        		compType,
        		"", "simcode");
        assemblyRole = new AssemblyRole();
        assemblyRole.setRoleName("aRole");
        assemblyType.addAssemblyRoleToAssemblyRoles(assemblyRole);
        assemblyRole.setAssemblyType(assemblyType);
        lru.addAssemblyTypeToAssemblyTypes(assemblyType);
        assemblyType.setLRUType(lru); // Again, this should be handled in the above method...
        session.save(lru);

        tx.commit();
        session.close();
        
        interceptor = new CompositeIdentifierInterceptor();
        session = HibernateUtil.getSessionFactory().openSession(interceptor);
        tx = session.beginTransaction();
        antenna = DomainEntityFactory.createTelescope("DV01",
        		TelescopeTypeEnum.SST2M,
        		new Coordinate(0.0, 0.0, 0.0),
        		4.5,
        		0L);
        config.addBaseElementToBaseElements(antenna);
        antenna.setHWConfiguration(config);
        pad = DomainEntityFactory.createPad("PAD01", new Coordinate(0.0, 0.0, 0.0), new Long(0));
        config.addBaseElementToBaseElements(pad);
        pad.setHWConfiguration(config); //TODO: Another case where this should be subsumed in the above method
        
        session.saveOrUpdate(config.getConfiguration());
        session.saveOrUpdate(config);

        @SuppressWarnings("unused") // actually used in persistence under the covers...
        TelescopeToPad a2p = DomainEntityFactory.createTelescopeToPad(antenna, pad, new Long(0), new Long(0), true);
        


        frontEnd = DomainEntityFactory.createCamera("ACamera", new Long(0));
        config.addBaseElementToBaseElements(frontEnd);
        frontEnd.setHWConfiguration(config); // TODO: Should be in above method!

        @SuppressWarnings("unused") // actually used in persistence under the covers...
        TelescopeToCamera a2fe = DomainEntityFactory.createTelescopeToCamera(antenna, frontEnd, new Long(0), new Long(0));

        startup = new Startup();
        startup.setStartupName("startup");
        startup.setHWConfiguration(config);
        config.addStartupToStartups(startup);
        baseElementStartup = new BaseElementStartup();
        baseElementStartup.setBaseElement(antenna);
        baseElementStartup.setBaseElementType(BEType.TELESCOPE);
        baseElementStartup.setStartup(startup);
        baseElementStartup.setSimulated(false);
        startup.addBaseElementStartupToBaseElementStartups(baseElementStartup);

        AssemblyStartup assemblyStartup = new AssemblyStartup();
        assemblyStartup.setBaseElementStartup(baseElementStartup);
        assemblyStartup.setAssemblyRole(assemblyRole);
        assemblyStartup.setSimulated(false);
        HashSet<AssemblyStartup> startups = new HashSet<AssemblyStartup>();
        startups.add(assemblyStartup);
        baseElementStartup.setAssemblyStartups(startups); // TODO: Verify that this is essentially what Rafael does

        session.saveOrUpdate(config.getConfiguration());
        session.saveOrUpdate(config);
        tx.commit();
        session.close();
        
        return startup;
	}
}
