package alma.tmcdb.utils;

import java.security.InvalidParameterException;
import java.util.Date;

import alma.BasebandNameMod.BasebandName;
import alma.NetSidebandMod.NetSideband;
import alma.PolarizationTypeMod.PolarizationType;
import alma.ReceiverBandMod.ReceiverBand;
import alma.acs.tmcdb.Telescope;
import alma.acs.tmcdb.TelescopeToCamera;
import alma.acs.tmcdb.TelescopeToPad;
import alma.acs.tmcdb.TelescopeTypeEnum;
import alma.acs.tmcdb.Assembly;
import alma.acs.tmcdb.AssemblyOnline;
import alma.acs.tmcdb.AssemblyRole;
import alma.acs.tmcdb.AssemblyStartup;
import alma.acs.tmcdb.AssemblyType;
import alma.acs.tmcdb.BEType;
import alma.acs.tmcdb.BEStartupBEType;
import alma.acs.tmcdb.BEType;
import alma.acs.tmcdb.BaseElement;
import alma.acs.tmcdb.BaseElementStartup;
import alma.acs.tmcdb.Camera;
import alma.acs.tmcdb.ComponentType;
import alma.acs.tmcdb.FocusModel;
import alma.acs.tmcdb.FocusModelCoeff;
import alma.acs.tmcdb.HWConfiguration;

import alma.acs.tmcdb.LRUType;
import alma.acs.tmcdb.Pad;
import alma.acs.tmcdb.PointingModel;
import alma.acs.tmcdb.PointingModelCoeff;
import alma.acs.tmcdb.Startup;
import alma.acs.tmcdb.WeatherStationController;


public class DomainEntityFactory {
	public static Telescope createTelescope(String name, TelescopeTypeEnum type, Coordinate position,
            double diameter, long commissionDate) {
		Telescope telescope = new Telescope();
		telescope.setBaseElementName(name);
		telescope.setBaseType(BEType.TELESCOPE);
		telescope.setTelescopeName(name);
		telescope.setTelescopeType(type);
		telescope.setLatitude(position.getX());
		telescope.setLongitude(position.getY());
		telescope.setAltitude(position.getZ());

		telescope.setDishDiameter(diameter);
		telescope.setCommissionDate(commissionDate);
		return telescope;
	}
	
	

	public static Pad createPad(String padName, Coordinate pos, Long commissionDate) {
		Pad pad = new Pad();
		pad.setBaseElementName(padName);
		pad.setBaseType(BEType.PAD);
		pad.setPadName(padName);
		pad.setXPosition(pos.getX());
		pad.setYPosition(pos.getY());
		pad.setZPosition(pos.getZ());
		pad.setCommissionDate(commissionDate);
		return pad;
	}
	
	public static Camera createCamera(String name, Long commissionDate) {
		Camera camera = new Camera();
		camera.setBaseElementName(name);
		camera.setBaseType(BEType.CAMERA);
		camera.setCommissionDate(commissionDate);
		return camera;
	}



	public static TelescopeToCamera createTelescopeToCamera(Telescope telescope, Camera camera, Long long1,
			Long long2) {
		TelescopeToCamera t2c = new TelescopeToCamera();
		t2c.setTelescope(telescope);
		t2c.setCamera(camera);
		// TODO Auto-generated method stub
		return t2c;
	}
	
	public static WeatherStationController createWeatherStationController(String name) {
		WeatherStationController wsc = new WeatherStationController();
		wsc.setBaseElementName(name);
		wsc.setBaseType(BEType.WEATHERSTATIONCONTROLLER);
		return wsc;
	}
	

	public static TelescopeToPad createTelescopeToPad(Telescope telescope, Pad pad,
			Long startTime, Long endTime, boolean planned) {
		TelescopeToPad a2p = new TelescopeToPad();
		a2p.setTelescope(telescope);
		a2p.setPad(pad);
		a2p.setStartTime(startTime);
		a2p.setEndTime(endTime);
		a2p.setPlanned(planned);
		pad.addTelescopeToPadToTelescopeToPads(a2p);
		telescope.addTelescopeToPadToTelescopeToPads(a2p);
//		a2p.setMountMetrologyAN0Coeff(0.0);
//		a2p.setMountMetrologyAW0Coeff(0.0);
		return a2p;
	}

	public static AssemblyType createAssemblyType(LRUType lru, String name,
			String fullName, BEType type, String description, String notes,
			ComponentType componentType, String productionCode, String simulationCode) {
		AssemblyType at = new AssemblyType();
		at.setAssemblyTypeName(name);
		at.setFullName(fullName);
		at.setBaseElementType(type);
		at.setDescription(description);
		at.setNotes(notes);
		at.setComponentType(componentType);
		at.setProductionCode(productionCode);
		at.setSimulatedCode(simulationCode);
		if (lru != null) {
			lru.addAssemblyTypeToAssemblyTypes(at);
			at.setLRUType(lru);
		}
		return at;
	}
	
	public static AssemblyType createAssemblyType(String name,
			String fullName, BEType type, String description, String notes,
			ComponentType componentType, String productionCode, String simulationCode) {
			return createAssemblyType(null, name, fullName, type, description, notes, componentType, productionCode, simulationCode);
	}

	public static LRUType createLRUType(String name, String fullName,
			String icd, long icdDate, String description, String notes) {
		LRUType ltype = new LRUType();
		ltype.setLRUName(name);
		ltype.setFullName(fullName);
		ltype.setICD(icd);
		ltype.setICDDate(icdDate);
		ltype.setDescription(description);
		ltype.setNotes(notes);
		return ltype;
	}


	public static AssemblyRole createAssemblyRole(String roleName) {
		AssemblyRole ar = new AssemblyRole();
		ar.setRoleName(roleName);
		return ar;
	}

	public static AssemblyStartup createAssemblyStartup(BaseElementStartup bes, AssemblyRole role) {
		AssemblyStartup as = new AssemblyStartup();
		as.setBaseElementStartup(bes);
		as.setAssemblyRole(role);
		bes.addAssemblyStartupToAssemblyStartups(as);
		return as;
	}

	public static BaseElementStartup createBaseElementStartup(BaseElement baseElement,Startup stup) {
		BaseElementStartup bes = new BaseElementStartup();
		bes.setBaseElement(baseElement);
		bes.setStartup(stup);
//	    if ((baseElement.getBaseType() != BEType.PHOTONICREFERENCE) &&
//	            (baseElement.getBaseType() != BEType.FRONTEND))
	        bes.setBaseElementType(BEType.valueOf(baseElement.getBaseType().name()));
//	    else
//	        throw new InvalidParameterException("BaseElement parameter must be non-generic");
	    bes.setIsGeneric("false");
	    stup.addBaseElementStartupToBaseElementStartups(bes);
	
		return bes;
	}

	public static Startup createStartup(String startupName) {
		Startup stup = new Startup();
		stup.setStartupName(startupName);
		return stup;
	}

	public static Assembly createAssembly(String serialNumber, String data,
			AssemblyType assemblyType) {
		Assembly assy = new Assembly();
		assy.setSerialNumber(serialNumber);
		assy.setData(data);
		assy.setAssemblyType(assemblyType);
		return assy;
	}
	
	public static AssemblyOnline createAssemblyOnline(Assembly assy, String roleName, Long time) {
		AssemblyOnline online = new AssemblyOnline();
		online.setAssembly(assy);
		online.setRoleName(roleName);
		online.setStartTime(time);
		return online;
	}

	public static BaseElementStartup createBaseElementStartup(
			BEType type) {
		BaseElementStartup bes = new BaseElementStartup();
		bes.setBaseElementType(type);
		bes.setIsGeneric("True");
		return bes;
	}

	public static FocusModel createFocusModel(Telescope antenna) {
		FocusModel fm = new FocusModel();
		fm.setTelescope(antenna);
		antenna.addFocusModelToFocusModels(fm);
		return fm;
	}

	public static PointingModel createPointingModel(Telescope antenna) {
		PointingModel pm = new PointingModel();
		pm.setTelescope(antenna);
		antenna.addPointingModelToPointingModels(pm);
		return pm;
	}


	public static FocusModelCoeff createFocusModelCoeff(String coeffName, double coeffValue) {
		FocusModelCoeff fmc  = new FocusModelCoeff();
		fmc.setCoeffName(coeffName);
		fmc.setCoeffValue(coeffValue);
		return fmc;
	}
	
	public static PointingModelCoeff createPointingModelCoeff(String coeffName,
			Double coeffValue) {
		PointingModelCoeff pmc = new PointingModelCoeff();
		pmc.setCoeffName(coeffName);
		pmc.setCoeffValue(coeffValue);
		return pmc;
	}




}
