/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * "@(#) $Id: CompositeIdentifierInterceptor.java,v 1.2 2009/03/30 16:48:46 rhiriart Exp $"
 */
package alma.tmcdb.utils;

import java.io.Serializable;

import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;

/**
 * A simple Hibernate Interceptor that will request persistent objects
 * that implement CompositeIdentifierUpdateable to update their composite
 * identifiers just before persisting them.
 * 
 * @author rhiriart
 * @see CompositeIdentifierUpdateable
 */
public class CompositeIdentifierInterceptor extends EmptyInterceptor {

    private static final long serialVersionUID = -1758564208183208352L;

    @Override
    public boolean onSave(Object entity,
                          Serializable id,
                          Object[] state,
                          String[] propertyNames,
                          Type[] types) {
        if (entity instanceof CompositeIdentifierUpdateable) {
            ((CompositeIdentifierUpdateable) entity).updateId();
        }
        return false;
    }

    
}
