package alma.tmcdb.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;

import alma.acs.tmcdb.TelescopeToPadTest;
import alma.acs.tmcdb.BL_TelescopeToPad;
import alma.acs.tmcdb.OperationEnum;
import alma.acs.tmcdb.TelescopeToPad;

public class TelescopeToPadHistorian extends Historian<TelescopeToPad, BL_TelescopeToPad>{

    public TelescopeToPadHistorian(Session session) {
        super(session);
    }

    public boolean prepareSave(Identifiable ent, String who, String description) {
        session.createSQLQuery("update antennatopad set increaseversion = '1' where antennatopadid = " + ent.getId()).executeUpdate();
        session.createSQLQuery("update antennatopad set who = '" + who + "' where antennatopadid = " + ent.getId()).executeUpdate();
	String nonNullDescription = (description == null || description.trim().equals("") ) ? "null" : description;
        session.createSQLQuery("update antennatopad set changedesc = :changeDescription where antennatopadid = " + ent.getId()).
	   setString("changeDescription", nonNullDescription).executeUpdate();
        return true;
    }

    public void endSave(Identifiable ent) {
        session.createSQLQuery("update antennatopad set increaseversion = '0' where antennatopadid = " + ent.getId()).executeUpdate();        
    }
    
    @Override
    protected List<Backloggable> getBackLogRecordsAsOf(long modtime, Long entityId) {
        List<Backloggable> list = new ArrayList<Backloggable>();
        Query query =
            session.createQuery("from BL_TelescopeToPad c where c.modTime > :modtime and antennaToPadId = :antennaToPadId");
        query.setParameter("modtime", modtime, Hibernate.LONG);
        query.setParameter("antennaToPadId", entityId, Hibernate.LONG);
        List<BL_TelescopeToPad> records = (List<BL_TelescopeToPad>) query.list();
        for (BL_TelescopeToPad r : records)
            list.add(r);
        Collections.sort(list, new BackLogComparator());
        return list;
    }

    @Override
    protected List<Backloggable> getBackLogRecords(long version, Long entityId) {
        List<Backloggable> list = new ArrayList<Backloggable>();
        Query query =
            session.createQuery("from BL_TelescopeToPad c where c.version > :version and antennaToPadId = :antennaToPadId");
        query.setParameter("version", version, Hibernate.LONG);
        query.setParameter("antennaToPadId", entityId, Hibernate.LONG);
        List<BL_TelescopeToPad> records = (List<BL_TelescopeToPad>) query.list();
        for (BL_TelescopeToPad r : records)
            list.add(r);
        Collections.sort(list, new BackLogComparator());
        return list;
    }

    @Override
    public Long getCurrentVersion(Long entityId) {
        Query query = session.createQuery("select max(version) " +
            "from BL_TelescopeToPad c where antennaToPadId = :entityId");
        query.setParameter("entityId", entityId, Hibernate.LONG);
        Long v = (Long) query.uniqueResult();
        if (v == null) {
            v = new Long(0);
        }
        return v;
    }

    @Override
    public Long getVersionAsOf(long modtime, Long entityId) {
        Query query = session.createQuery("select max(version) " +
            "from BL_TelescopeToPad c where c.modTime < :modtime and antennaToPadId = :entityId");
        query.setParameter("entityId", entityId, Hibernate.LONG);
        query.setParameter("modtime", modtime, Hibernate.LONG);
        Long v = (Long) query.uniqueResult();
        if (v == null) {
            v = new Long(0);
        }
        return v;
    }
    
    @Override
    protected void reverse(BL_TelescopeToPad change, TelescopeToPad antennatopad) {
        OperationEnum op = change.getOperation();
//        if (op == OperationEnum.U) {
//            antennatopad.setMountMetrologyAN0Coeff(change.getMountMetrologyAN0Coeff());
//            antennatopad.setMountMetrologyAW0Coeff(change.getMountMetrologyAW0Coeff());
//        }
    }

    @Override
    protected TelescopeToPad clone(TelescopeToPad entity) {
        TelescopeToPad retVal = new TelescopeToPad();
	retVal.setTelescope(entity.getTelescope());
	retVal.setPad(entity.getPad());
//        retVal.setMountMetrologyAN0Coeff(entity.getMountMetrologyAN0Coeff());
//        retVal.setMountMetrologyAW0Coeff(entity.getMountMetrologyAW0Coeff());
        return retVal;
    }    
}
