package alma.tmcdb.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;

import alma.tmcdb.utils.Coordinate;
import alma.tmcdb.utils.DomainEntityFactory;
import alma.acs.tmcdb.Telescope;
import alma.acs.tmcdb.TelescopeTypeEnum;
import alma.acs.tmcdb.BL_Telescope;
import alma.acs.tmcdb.OperationEnum;

public class TelescopeHistorian extends Historian<Telescope, BL_Telescope>{

    public TelescopeHistorian(Session session) {
        super(session);
    }

    public boolean prepareSave(Identifiable ent, String who, String description) {
        session.createSQLQuery("update antenna set increaseversion = '1' where baseelementid = " + ent.getId()).executeUpdate();
        session.createSQLQuery("update antenna set who = '" + who + "' where baseelementid = " + ent.getId()).executeUpdate();
	String nonNullDescription = (description == null || description.trim().equals("") ) ? "null" : description;
        session.createSQLQuery("update antenna set changedesc = :changeDescription where baseelementid = " + ent.getId()).
	   setString("changeDescription", nonNullDescription).executeUpdate();
        return true;
    }

    public void endSave(Identifiable ent) {
        session.createSQLQuery("update antenna set increaseversion = '0' where baseelementid = " + ent.getId()).executeUpdate();        
    }
    
    @Override
    protected List<Backloggable> getBackLogRecordsAsOf(long modtime, Long entityId) {
        List<Backloggable> list = new ArrayList<Backloggable>();
        Query query =
            session.createQuery("from BL_Telescope c where c.modTime > :modtime and baseElementId = :baseElementId");
        query.setParameter("modtime", modtime, Hibernate.LONG);
        query.setParameter("baseElementId", entityId, Hibernate.LONG);
        List<BL_Telescope> records = (List<BL_Telescope>) query.list();
        for (BL_Telescope r : records)
            list.add(r);
        Collections.sort(list, new BackLogComparator());
        return list;
    }

    @Override
    protected List<Backloggable> getBackLogRecords(long version, Long entityId) {
        List<Backloggable> list = new ArrayList<Backloggable>();
        Query query =
            session.createQuery("from BL_Telescope c where c.version > :version and baseElementId = :baseElementId");
        query.setParameter("version", version, Hibernate.LONG);
        query.setParameter("baseElementId", entityId, Hibernate.LONG);
        List<BL_Telescope> records = (List<BL_Telescope>) query.list();
        for (BL_Telescope r : records)
            list.add(r);
        Collections.sort(list, new BackLogComparator());
        return list;
    }

    @Override
    public Long getCurrentVersion(Long entityId) {
        Query query = session.createQuery("select max(version) " +
            "from BL_Telescope c where baseElementId = :baseElementId");
        query.setParameter("baseElementId", entityId, Hibernate.LONG);
        Long v = (Long) query.uniqueResult();
        if (v == null) {
            v = new Long(0);
        }
        return v;
    }

    @Override
    public Long getVersionAsOf(long modtime, Long entityId) {
        Query query = session.createQuery("select max(version) " +
            "from BL_Telescope c where c.modTime < :modtime and baseElementId = :baseElementId");
        query.setParameter("baseElementId", entityId, Hibernate.LONG);
        query.setParameter("modtime", modtime, Hibernate.LONG);
        Long v = (Long) query.uniqueResult();
        if (v == null) {
            v = new Long(0);
        }
        return v;
    }
    
    @Override
    protected void reverse(BL_Telescope change, Telescope antenna) {
        OperationEnum op = change.getOperation();
        if (op == OperationEnum.U) {
            antenna.setCommissionDate(change.getCommissionDate());
            antenna.setDishDiameter(change.getDishDiameter());
            antenna.setTelescopeType(TelescopeTypeEnum.valueOf(change.getTelescopeType().toString()));
            antenna.setLatitude(change.getXPosition());
            antenna.setLongitude(change.getYPosition());
            antenna.setAltitude(change.getZPosition());

        }
    }

    @Override
    protected Telescope clone(Telescope entity) {
    	Coordinate pos = new Coordinate(entity.getLatitude(),
                entity.getLongitude(), entity.getAltitude());
        Telescope retVal = DomainEntityFactory.createTelescope(entity.getBaseElementName(), entity.getTelescopeType(),  pos, entity.getDishDiameter(), entity.getCommissionDate());
       return retVal;
    }
}
