package alma.tmcdb.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;

import alma.tmcdb.utils.Coordinate;
import alma.tmcdb.utils.DomainEntityFactory;
import alma.acs.tmcdb.BL_Pad;
import alma.acs.tmcdb.OperationEnum;
import alma.acs.tmcdb.Pad;

public class PadHistorian extends Historian<Pad, BL_Pad>{

    public PadHistorian(Session session) {
        super(session);
    }

    public boolean prepareSave(Identifiable ent, String who, String description) {
        session.createSQLQuery("update pad set increaseversion = '1' where baseelementid = " + ent.getId()).executeUpdate();
        session.createSQLQuery("update pad set who = '" + who + "' where baseelementid = " + ent.getId()).executeUpdate();
	String nonNullDescription = (description == null || description.trim().equals("") ) ? "null" : description;
        session.createSQLQuery("update pad set changedesc = :changeDescription where baseelementid = " + ent.getId()).
	   setString("changeDescription", nonNullDescription).executeUpdate();
        return true;
    }

    public void endSave(Identifiable ent) {
        session.createSQLQuery("update pad set increaseversion = '0' where baseelementid = " + ent.getId()).executeUpdate();        
    }
    
    @Override
    protected List<Backloggable> getBackLogRecordsAsOf(long modtime, Long entityId) {
        List<Backloggable> list = new ArrayList<Backloggable>();
        Query query =
            session.createQuery("from BL_Pad c where c.modTime > :modtime and baseElementId = :baseElementId");
        query.setParameter("modtime", modtime, Hibernate.LONG);
        query.setParameter("baseElementId", entityId, Hibernate.LONG);
        List<BL_Pad> records = (List<BL_Pad>) query.list();
        for (BL_Pad r : records)
            list.add(r);
        Collections.sort(list, new BackLogComparator());
        return list;
    }

    @Override
    protected List<Backloggable> getBackLogRecords(long version, Long entityId) {
        List<Backloggable> list = new ArrayList<Backloggable>();
        Query query =
            session.createQuery("from BL_Pad c where c.version > :version and baseElementId = :baseElementId");
        query.setParameter("version", version, Hibernate.LONG);
        query.setParameter("baseElementId", entityId, Hibernate.LONG);
        List<BL_Pad> records = (List<BL_Pad>) query.list();
        for (BL_Pad r : records)
            list.add(r);
        Collections.sort(list, new BackLogComparator());
        return list;
    }

    @Override
    public Long getCurrentVersion(Long entityId) {
        Query query = session.createQuery("select max(version) " +
            "from BL_Pad c where baseElementId = :baseElementId");
        query.setParameter("baseElementId", entityId, Hibernate.LONG);
        Long v = (Long) query.uniqueResult();
        if (v == null) {
            v = new Long(0);
        }
        return v;
    }

    @Override
    public Long getVersionAsOf(long modtime, Long entityId) {
        Query query = session.createQuery("select max(version) " +
            "from BL_Pad c where c.modTime < :modtime and baseElementId = :baseElementId");
        query.setParameter("baseElementId", entityId, Hibernate.LONG);
        query.setParameter("modtime", modtime, Hibernate.LONG);
        Long v = (Long) query.uniqueResult();
        if (v == null) {
            v = new Long(0);
        }
        return v;
    }
    
    @Override
    protected void reverse(BL_Pad change, Pad pad) {
        OperationEnum op = change.getOperation();
        if (op == OperationEnum.U) {
            pad.setCommissionDate(change.getCommissionDate());
            pad.setXPosition(change.getXPosition());
            pad.setYPosition(change.getYPosition());
            pad.setZPosition(change.getZPosition());
        }
    }

    @Override
    protected Pad clone(Pad entity) {
    	Pad retVal = DomainEntityFactory.createPad(entity.getBaseElementName(), new Coordinate(entity.getXPosition(),
                entity.getYPosition(), entity.getZPosition()), entity.getCommissionDate());
        return retVal;
    }
}
