/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * "@(#) $Id: XPDelay.java,v 1.8 2012/02/16 01:39:10 sharring Exp $"
 */
package alma.tmcdb.domain;

import alma.BasebandNameMod.BasebandName;
import alma.NetSidebandMod.NetSideband;
import alma.ReceiverBandMod.ReceiverBand;

public class XPDelay {

    private HwConfiguration configuration;
    private Long id;
    private ReceiverBand receiverBand;
    private BasebandName baseband;
    private NetSideband sideband;
    private Double delay;
    
    public XPDelay() {}

    public XPDelay(ReceiverBand receiverBand, BasebandName baseband, NetSideband sideband,
            double delay, HwConfiguration config) 
    {
        this.receiverBand = receiverBand;
        this.baseband = baseband;
        this.sideband = sideband;
        this.delay = delay;
        this.configuration = config;
    }

	@Override
	public int hashCode() 
	{
		final int prime = 31;
		int result = 1;

		result = prime * result + ((getReceiverBand() == null) ? 0 : getReceiverBand().hashCode());
		result = prime * result + ((getBaseband() == null) ? 0 : getBaseband().hashCode());
		result = prime * result + ((getSideband() == null) ? 0 : getSideband().hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) 
	{
		if (this == obj)
		{
			return true;
		}
		if (obj == null)
		{
			return false;
		}
		if (getClass() != obj.getClass())
		{
			return false;
		}
		XPDelay other = (XPDelay) obj;
		if (getBaseband() == null) 
		{
			if (other.getBaseband() != null)
			{
				return false;
			}
		} 
		else if (!getBaseband().equals(other.getBaseband())) 
		{
			return false;
		}
		if (getReceiverBand() == null) 
		{
			if (other.getReceiverBand() != null)
			{
				return false;
			}
		} 
		else if (!getReceiverBand().equals(other.getReceiverBand()))
		{
			return false;
		}
		if (getSideband() == null) 
		{
			if (other.getSideband() != null)
			{
				return false;
			}
		} 
		else if (!getSideband().equals(other.getSideband()))
		{
			return false;
		}
		return true;
	}

    public HwConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(HwConfiguration configuration) {
        this.configuration = configuration;
    }

    public Long getId() {
        return id;
    }
    
    public void setId(Long id) {
        this.id = id;
    }
    
    public BasebandName getBaseband() {
        return baseband;
    }
    
    public void setBaseband(BasebandName baseband) {
        this.baseband = baseband;
    }
    
    public NetSideband getSideband() {
        return sideband;
    }
    
    public void setSideband(NetSideband sideband) {
        this.sideband = sideband;
    }
    
    public Double getDelay() {
        return delay;
    }
    
    public void setDelay(Double delay) {
        this.delay = delay;
    }

    public ReceiverBand getReceiverBand() {
        return receiverBand;
    }

    public void setReceiverBand(ReceiverBand receiverBand) {
        this.receiverBand = receiverBand;
    }
}
