/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * "@(#) $Id: LODelay.java,v 1.5 2012/01/11 23:44:17 sharring Exp $"
 */
package alma.tmcdb.domain;

import alma.BasebandNameMod.BasebandName;

public class LODelay {

	private Long id;
    private BasebandName baseband;
    private Double delay;
    
    public LODelay() {}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((getBaseband() == null) ? 0 : getBaseband().hashCode());
		result = prime * result + ((getDelay() == null) ? 0 : getDelay().hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		LODelay other = (LODelay) obj;
		if (getBaseband() == null) {
			if (other.getBaseband() != null)
				return false;
		} else if (!getBaseband().equals(other.getBaseband()))
			return false;
		if (getDelay() == null) {
			if (other.getDelay() != null)
				return false;
		} else if (!getDelay().equals(other.getDelay()))
			return false;
		return true;
	}
	
	public LODelay(BasebandName baseband, double delay) {
        this.baseband = baseband;
        this.delay = delay;
    }
    
    public Long getId() {
        return id;
    }
    
    public void setId(Long id) {
        this.id = id;
    }
    
    public BasebandName getBaseband() {
        return baseband;
    }
    
    public void setBaseband(BasebandName baseband) {
        this.baseband = baseband;
    }
    
    public Double getDelay() {
        return delay;
    }
    
    public void setDelay(Double delay) {
        this.delay = delay;
    }
}
