/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * "@(#) $Id: IFDelay.java,v 1.7 2012/02/16 01:39:10 sharring Exp $"
 */
package alma.tmcdb.domain;

import alma.BasebandNameMod.BasebandName;
import alma.PolarizationTypeMod.PolarizationType;

public class IFDelay {

	private Long id;
    private BasebandName baseband;
    private PolarizationType polarization;
    private IFProcConnectionState ifSwitch;
    private Double delay;
    
    public IFDelay() {}

    public IFDelay(BasebandName baseband, PolarizationType polarization, IFProcConnectionState ifSwitch,
            double delay) {
        this.baseband = baseband;
        this.polarization = polarization;
        this.ifSwitch = ifSwitch;
        this.delay = delay;
    }
    
    @Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((getBaseband() == null) ? 0 : getBaseband().hashCode());
		result = prime * result
				+ ((getIfSwitch() == null) ? 0 : getIfSwitch().hashCode());
		result = prime * result
				+ ((getPolarization() == null) ? 0 : getPolarization().hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		IFDelay other = (IFDelay) obj;

		// Baseband
		if (getBaseband() == null) {
			if (other.getBaseband() != null)
				return false;
		} else if (!getBaseband().equals(other.getBaseband()))
			return false;

		// Ifswitch
		if (getIfSwitch() == null) {
			if (other.getIfSwitch() != null)
				return false;
		} else if (!getIfSwitch().equals(other.getIfSwitch()))
			return false;

		// Polarization
		if (getPolarization() == null) {
			if (other.getPolarization() != null)
				return false;
		} else if (!getPolarization().equals(other.getPolarization()))
			return false;

		return true;
	}

	public Long getId() {
        return id;
    }
    
    public void setId(Long id) {
        this.id = id;
    }
    
    public BasebandName getBaseband() {
        return baseband;
    }
    
    public void setBaseband(BasebandName baseband) {
        this.baseband = baseband;
    }
    
    public PolarizationType getPolarization() {
        return polarization;
    }
    
    public void setPolarization(PolarizationType polarization) {
        this.polarization = polarization;
    }
    
    public Double getDelay() {
        return delay;
    }
    
    public void setDelay(Double delay) {
        this.delay = delay;
    }

    public IFProcConnectionState getIfSwitch() {
        return ifSwitch;
    }

    public void setIfSwitch(IFProcConnectionState ifSwitch) {
        this.ifSwitch = ifSwitch;
    }
}
