/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * "@(#) $Id: HwSchema.java,v 1.2 2010/08/31 09:45:25 rtobar Exp $"
 */
package alma.tmcdb.domain;

public class HwSchema {

	private Long id;
	private String urn;
    private HwConfiguration configuration;
    private AssemblyType assemblyType;
    private String schema;

    public HwSchema() { }
    
    public HwSchema(String urn, String schema) {
    	this.urn = urn;
    	this.schema = schema;
    }
    
	public Long getId() {
		return id;
	}
	
	public void setId(Long id) {
		this.id = id;
	}
	
	public String getUrn() {
		return urn;
	}
	
	public void setUrn(String urn) {
		this.urn = urn;
	}
	
	public HwConfiguration getConfiguration() {
		return configuration;
	}
	
	public void setConfiguration(HwConfiguration configuration) {
		this.configuration = configuration;
	}
	
	public String getSchema() {
		return schema;
	}
	
	public void setSchema(String schema) {
		this.schema = schema;
	}

	public void setAssemblyType(AssemblyType assemblyType) {
		this.assemblyType = assemblyType;
	}

	public AssemblyType getAssemblyType() {
		return assemblyType;
	}
}
