/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * "@(#) $Id: FocusModelCoeff.java,v 1.4 2012/01/11 23:44:17 sharring Exp $"
 */
package alma.tmcdb.domain;

import java.util.HashMap;
import java.util.Map;

import alma.ReceiverBandMod.ReceiverBand;

public class FocusModelCoeff {
    
    private Long id;
    private float value;
    private String name;
    private Map<ReceiverBand, Double> offsets = new HashMap<ReceiverBand, Double>();

    public FocusModelCoeff() { }

    public FocusModelCoeff(String name, float value) {
    	this.name = name;
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this)
            return true;
        if (!(o instanceof FocusModelCoeff))
            return false;
        FocusModelCoeff other = (FocusModelCoeff) o;
        if (getName() == null) {
            if (other.getName() != null)
                return false;
        } else if (!getName().equals(other.getName()))
            return false;
        if (!(Double.compare(getValue(), other.getValue()) == 0))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + getName().hashCode();
        result = 31 * result + Float.floatToIntBits(getValue());
        return result;
    }
    
    public float getValue() {
        return value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public Map<ReceiverBand, Double> getOffsets() {
        return offsets;
    }

    public void setOffsets(Map<ReceiverBand, Double> offsets) {
        this.offsets = offsets;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
}
