/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * "@(#) $Id: FocusModel.java,v 1.7 2012/01/11 23:44:17 sharring Exp $"
 */
package alma.tmcdb.domain;

import java.util.HashMap;
import java.util.Map;

import alma.tmcdb.history.Identifiable;
import alma.tmcdb.history.Version;

public class FocusModel implements Identifiable {

	private Long id;
    private Antenna antenna;
    private Map<String, FocusModelCoeff> terms = new HashMap<String, FocusModelCoeff>();
    
    public FocusModel() {}

    public FocusModel(Antenna antenna) {
        this.antenna = antenna;
        antenna.getFocusModels().add(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this)
            return true;
        if (!(o instanceof FocusModel))
            return false;
        FocusModel fm = (FocusModel) o;
        return (getAntenna() == null ? fm.getAntenna() == null : getAntenna().equals(fm.getAntenna()));
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + ((getAntenna() == null) ? 0 : getAntenna().hashCode());
        return result;
    }
    
    public Antenna getAntenna() {
        return antenna;
    }

    public void setAntenna(Antenna antenna) {
        this.antenna = antenna;
    }

    public Map<String, FocusModelCoeff> getTerms() {
        return terms;
    }

    public void setTerms(Map<String, FocusModelCoeff> coeffs) {
        this.terms = coeffs;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public FocusModelCoeff getTerm(String coeffname) {
        return terms.get(coeffname);
    }
}
