/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * "@(#) $Id: CorrQuadrant.java,v 1.1 2012/08/20 23:55:01 sharring Exp $"
 */
package alma.tmcdb.domain;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import alma.acs.util.UTCUtility;
import alma.BasebandNameMod.BasebandName;

public class CorrQuadrant extends BaseElement {

    private BasebandName baseband;
    private Byte quadrant;
    private Byte channelNumber;

    public CorrQuadrant() {}

    public CorrQuadrant(String corrName, BasebandName baseband, Byte quadrant, Byte channel) 
    {
        super(null, corrName, BaseElementType.CorrQuadrant);
        this.baseband = baseband;
        this.quadrant = quadrant;
        this.channelNumber = channel;
    }

    public Byte getQuadrant() {
        return this.quadrant;
    }
 
    public void setQuadrant(Byte quadrant) {
        this.quadrant = quadrant;
    }

    public Byte getChannelNumber() {
        return this.channelNumber;
    }
 
    public void setChannelNumber(Byte channelNumber) {
        this.channelNumber = channelNumber;
    }

    public BasebandName getBaseband() {
        return baseband;
    }
    
    public void setBaseband(BasebandName baseband) {
        this.baseband = baseband;
    }
}
