/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * "@(#) $Id: ConcreteBaseElementStartup.java,v 1.1 2009/04/08 14:38:44 rhiriart Exp $"
 */
package alma.tmcdb.domain;

public class ConcreteBaseElementStartup extends AbstractBaseElementStartup {

    private StartupScenario startup;
    private BaseElement baseElement;

    public ConcreteBaseElementStartup(StartupScenario startup,
                                      BaseElement baseElement) {
        super();
        this.startup = startup;
        this.baseElement = baseElement;
        this.type = baseElement.getType();
        // TODO if (startup != null) startup.addBaseElementStartup(this);
    }

    public ConcreteBaseElementStartup(BaseElement baseElement) {
        this(null, baseElement);
    }
    
    public StartupScenario getStartup() {
        return startup;
    }

    public void setStartup(StartupScenario startup) {
        this.startup = startup;
    }

    public BaseElement getBaseElement() {
        return baseElement;
    }

    public void setBaseElement(BaseElement baseElement) {
        this.baseElement = baseElement;
    }
}
