/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 */
package alma.tmcdb.domain;

import java.util.HashSet;
import java.util.Set;

public class BaseElementOnline {

    private Long id;
    
    private HwConfiguration hwConfiguration;
    
    private BaseElement baseElement;
    
    private Long startTime;
    
    private Long endTime;
    
    private Boolean normalTermination;
    
    private Set<AssemblyOnline> onlineAssemblies = new HashSet<AssemblyOnline>();;

    public BaseElementOnline() { }
    
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((getBaseElement() == null) ? 0 : getBaseElement().hashCode());
        result = prime * result
                + ((getHwConfiguration() == null) ? 0 : getHwConfiguration().hashCode());
        result = prime * result
                + ((getStartTime() == null) ? 0 : getStartTime().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        BaseElementOnline other = (BaseElementOnline) obj;
        if (getBaseElement() == null) {
            if (other.getBaseElement() != null)
                return false;
        } else if (!getBaseElement().equals(other.getBaseElement()))
            return false;
        if (getHwConfiguration() == null) {
            if (other.getHwConfiguration() != null)
                return false;
        } else if (!getHwConfiguration().equals(other.getHwConfiguration()))
            return false;
        if (getStartTime() == null) {
            if (other.getStartTime() != null)
                return false;
        } else if (!getStartTime().equals(other.getStartTime()))
            return false;
        return true;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public HwConfiguration getHwConfiguration() {
        return hwConfiguration;
    }

    public void setHwConfiguration(HwConfiguration hwConfiguration) {
        this.hwConfiguration = hwConfiguration;
    }

    public BaseElement getBaseElement() {
        return baseElement;
    }

    public void setBaseElement(BaseElement baseElement) {
        this.baseElement = baseElement;
    }

    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Boolean getNormalTermination() {
        return normalTermination;
    }

    public void setNormalTermination(Boolean normalTermination) {
        this.normalTermination = normalTermination;
    }

    public Set<AssemblyOnline> getOnlineAssemblies() {
        return onlineAssemblies;
    }

    public void setOnlineAssemblies(Set<AssemblyOnline> onlineAssemblies) {
        this.onlineAssemblies = onlineAssemblies;
    }
}
