/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * "@(#) $Id: AssemblyStartup.java,v 1.14 2012/01/11 23:44:17 sharring Exp $"
 */
package alma.tmcdb.domain;


public class AssemblyStartup {
    
    private Long id;
    private BaseElementStartup baseElementStartup;
    private AssemblyRole assemblyRole;
    private Boolean simulated;
    
    public AssemblyStartup() {}
        
    public AssemblyStartup(BaseElementStartup baseElementStartup,
            AssemblyRole assemblyRole) {
        this.assemblyRole = assemblyRole;
        
        baseElementStartup.addAssemblyStartup(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this)
            return true;
        if (!(o instanceof AssemblyStartup))
            return false;
        AssemblyStartup as = (AssemblyStartup) o;
        return (getBaseElementStartup() == null ? as.getBaseElementStartup() == null :
                   getBaseElementStartup().equals(as.getBaseElementStartup())) &&
               (getAssemblyRole() == null ? as.getAssemblyRole() == null :
                   getAssemblyRole().equals(as.getAssemblyRole()));
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + ((getBaseElementStartup() == null) ? 0 :
            getBaseElementStartup().hashCode());
        result = 31 * result + ((getAssemblyRole() == null) ? 0 :
            getAssemblyRole().hashCode());
        return result;
    }
    
    public Long getId() {
        return id;
    }
    
    public void setId(Long id) {
        this.id = id;
    }

    public AssemblyRole getAssemblyRole() {
        return assemblyRole;
    }

    public void setAssemblyRole(AssemblyRole assemblyRole) {
        this.assemblyRole = assemblyRole;
    }

    public BaseElementStartup getBaseElementStartup() {
        return baseElementStartup;
    }

    public void setBaseElementStartup(BaseElementStartup baseElementStartup) {
        this.baseElementStartup = baseElementStartup;
    }

    public Boolean getSimulated() {
        return simulated;
    }

    public void setSimulated(Boolean sim) {
        this.simulated = sim;
    }
}
