/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 */
package alma.tmcdb.domain;

public class AssemblyOnline {

    private Long id;
    
    private Assembly assembly;
    
    private String roleName;
    
    private Long startTime;
    
    private Long endTime;
    
    private BaseElementOnline onlineBaseElement;
    
    public AssemblyOnline() { }
    
    public AssemblyOnline(Assembly assembly, String roleName, Long startTime) {
        this.assembly = assembly;
        this.roleName = roleName;
        this.startTime = startTime;
    }
    
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((getAssembly() == null) ? 0 : getAssembly().hashCode());
        result = prime * result
                + ((getStartTime() == null) ? 0 : getStartTime().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AssemblyOnline other = (AssemblyOnline) obj;
        if (getAssembly() == null) {
            if (other.getAssembly() != null)
                return false;
        } else if (!getAssembly().equals(other.getAssembly()))
            return false;
        if (getStartTime() == null) {
            if (other.getStartTime() != null)
                return false;
        } else if (!getStartTime().equals(other.getStartTime()))
            return false;
        return true;
    }    
    
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Assembly getAssembly() {
        return assembly;
    }

    public void setAssembly(Assembly assembly) {
        this.assembly = assembly;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public BaseElementOnline getOnlineBaseElement() {
        return onlineBaseElement;
    }

    public void setOnlineBaseElement(BaseElementOnline onlineBaseElement) {
        this.onlineBaseElement = onlineBaseElement;
    }
}
