/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * "@(#) $Id: Assembly.java,v 1.8 2012/01/11 23:44:17 sharring Exp $"
 */
package alma.tmcdb.domain;

public class Assembly {

    private Long id;
    private HwConfiguration configuration;
    private String serialNumber;
    private String data;
    private AssemblyType assemblyType;

    public Assembly() {}
    
    public Assembly(String serialNumber, String data, AssemblyType assemblyType) {
        this.serialNumber = serialNumber;
        this.data = data;
        this.assemblyType = assemblyType;
    }
    
    @Override
    public boolean equals(Object o) {
        if (o == this)
            return true;
        if (!(o instanceof Assembly))
            return false;
        Assembly asm = (Assembly) o;
        return (getConfiguration() == null ? asm.getConfiguration() == null :
                getConfiguration().equals(asm.getConfiguration())) &&
               (getSerialNumber() == null ? asm.getSerialNumber() == null :
                getSerialNumber().equals(asm.getSerialNumber()));
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + ((getConfiguration() == null) ? 0 : getConfiguration().hashCode());
        result = 31 * result + ((getSerialNumber() == null) ? 0 : getSerialNumber().hashCode());
        return result;
    }
    
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public HwConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(HwConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public AssemblyType getAssemblyType() {
        return assemblyType;
    }

    public void setAssemblyType(AssemblyType assemblyType) {
        this.assemblyType = assemblyType;
    }
}
