/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * "@(#) $Id: AntennaToFrontEnd.java,v 1.11 2012/01/11 23:44:17 sharring Exp $"
 */
package alma.tmcdb.domain;

import java.io.Serializable;
import java.util.Date;

import alma.acs.util.UTCUtility;

public class AntennaToFrontEnd 
{
    private Integer antennaToFrontEndId;
    private Long startTime;
    private Long endTime;
    private Antenna antenna;
    private FrontEnd frontEnd;
    
    public AntennaToFrontEnd() {}

    public AntennaToFrontEnd(Antenna antenna, FrontEnd frontEnd, Date startTime, Date endTime) {
        this(antenna, frontEnd, UTCUtility.utcJavaToOmg(startTime.getTime()),
        		UTCUtility.utcJavaToOmg(endTime.getTime()));
    }
    
    public AntennaToFrontEnd(Antenna antenna, FrontEnd frontEnd, Long startTime, Long endTime) {        
        this.antenna = antenna;
        this.frontEnd = frontEnd;
        this.startTime = startTime;
        this.endTime = endTime;
        this.frontEnd.getScheduledAntennaInstallations().add(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this)
            return true;
        if (!(o instanceof AntennaToFrontEnd))
            return false;
        AntennaToFrontEnd a2fe = (AntennaToFrontEnd) o;
        return (getAntenna() == null ? a2fe.getAntenna() == null :
                getAntenna().equals(a2fe.getAntenna())) &&
               (getFrontEnd() == null ? a2fe.getFrontEnd() == null :
                getFrontEnd().equals(a2fe.getFrontEnd())) &&
               (getStartTime() == null ? a2fe.getStartTime() == null :
                getStartTime().equals(a2fe.getStartTime()));
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + ((getAntenna() == null) ? 0 : getAntenna().hashCode());
        result = 31 * result + ((getFrontEnd() == null) ? 0 : getFrontEnd().hashCode());
        result = 31 * result + ((getStartTime() == null) ? 0 : getStartTime().hashCode());
        return result;
    }
    
    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return endTime;
    }
    
    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }
    
    public Antenna getAntenna() {
        return antenna;
    }
    
    public void setAntenna(Antenna antenna) {
        this.antenna = antenna;
    }
    
    public FrontEnd getFrontEnd() {
        return frontEnd;
    }
    
    public void setFrontEnd(FrontEnd frontEnd) {
        this.frontEnd = frontEnd;
    }

    public Integer getAntennaToFrontEndId() {
        return antennaToFrontEndId;
    }

    public void setAntennaToFrontEndId(Integer id) {
        this.antennaToFrontEndId = id;
    }
}
