/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * "@(#) $Id: AcaCorrSet.java,v 1.1 2012/08/20 23:55:01 sharring Exp $"
 */
package alma.tmcdb.domain;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import alma.acs.util.UTCUtility;
import alma.BasebandNameMod.BasebandName;

public class AcaCorrSet extends BaseElement {

    private BasebandName baseband;
    private String ip;

    public AcaCorrSet() {}

    public AcaCorrSet(String name, BasebandName baseband, String ip) 
    {
        super(null, name, BaseElementType.AcaCorrSet);
        this.baseband = baseband;
        this.ip = ip;
    }

    public String getIp() {
        return this.ip;
    }
 
    public void setIp(String ip) {
        this.ip = ip;
    }

    public BasebandName getBaseband() {
        return baseband;
    }
    
    public void setBaseband(BasebandName baseband) {
        this.baseband = baseband;
    }
}
