/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * "@(#) $Id: AcaCorrDelays.java,v 1.1 2012/11/15 21:28:15 sharring Exp $"
 */
package alma.tmcdb.domain;

import java.util.Date;

import alma.tmcdb.history.Identifiable;
import alma.acs.util.UTCUtility;

public class AcaCorrDelays implements Identifiable
{
    private Long antennaId;
    private Antenna antenna;
    private Double delayBbOne;
    private Double delayBbTwo;
    private Double delayBbThree;
    private Double delayBbFour;
    
    public AcaCorrDelays() {}

    public AcaCorrDelays(Antenna antenna, Double bbOneDelay, Double bbTwoDelay, Double bbThreeDelay, Double bbFourDelay) 
    {
	this.antenna = antenna;
	this.delayBbOne = bbOneDelay;
	this.delayBbTwo = bbTwoDelay;
	this.delayBbThree = bbThreeDelay;
	this.delayBbFour = bbFourDelay;
    }
    
    @Override
    public boolean equals(Object o) {
        if (o == this)
            return true;
        if (!(o instanceof AcaCorrDelays))
            return false;
        AcaCorrDelays delays = (AcaCorrDelays) o;
        return (getAntenna() == null ? delays.getAntenna() == null :
                getAntenna().equals(delays.getAntenna()));
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + ((getAntenna() == null) ? 0 : getAntenna().hashCode());
        return result;
    }
    
    public Antenna getAntenna() {
        return antenna;
    }

    public void setAntenna(Antenna antenna) {
        this.antenna = antenna;
    }

    /**
     * Implementation of Identifiable interface requires this method,
     * which in our case is somewhat redundant (we already have the getAntennaId 
     * method; however the interface requires a naming convention to which this class
     * did not already adhere. Easiest solution is simply a redundant method, however
     * we could consider a refactoring to rename antennaId --> id, in the future.
     */
    public Long getId() {
        return getAntennaId();
    }

    public Long getAntennaId() {
        return antennaId;
    }

    public void setAntennaId(Long antennaId) {
        this.antennaId = antennaId;
    }

    public Double getDelayBbOne() {
        return delayBbOne;
    }

    public void setDelayBbOne(Double delay) {
        this.delayBbOne = delay;
    }

    public Double getDelayBbTwo() {
        return delayBbTwo;
    }

    public void setDelayBbTwo(Double delay) {
        this.delayBbTwo = delay;
    }

    public Double getDelayBbThree() {
        return delayBbThree;
    }

    public void setDelayBbThree(Double delay) {
        this.delayBbThree = delay;
    }

    public Double getDelayBbFour() {
        return delayBbFour;
    }

    public void setDelayBbFour(Double delay) {
        this.delayBbFour = delay;
    }
}
