package alma.tmcdb.cloning;

import alma.acs.tmcdb.Component;

/**
 * A {@link ComponentNameReplacer} that replaces a component's name based on
 * an old and new antenna names.
 *
 * @author rtobar, Apr 28th, 2011
 *
 */
public class TelescopeComponentNameReplacer implements ComponentNameReplacer {

	private String _oldTelescopeName;
	private String _newTelescopeName;

	public TelescopeComponentNameReplacer(String oldTelescopeName, String newTelescopeName) {
		_oldTelescopeName = oldTelescopeName;
		_newTelescopeName = newTelescopeName;
	}

	@Override
	public void replaceName(Component comp) {
		if( comp.getComponentName().equals(_oldTelescopeName) )
			comp.setComponentName(_newTelescopeName);
		else
			comp.setPath( comp.getPath().replaceAll(_oldTelescopeName, _newTelescopeName) );
	}

}
