package alma.tmcdb.cloning;

import net.sf.beanlib.PropertyInfo;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.CustomBeanTransformerSpi;
import alma.acs.tmcdb.ComponentType;
import alma.acs.tmcdb.Contact;
import alma.acs.tmcdb.LRUType;
import alma.acs.tmcdb.Location;
//import alma.acs.tmcdb.ArrayReference;
import alma.acs.tmcdb.AssemblyRole;
import alma.acs.tmcdb.AssemblyType;
import alma.tmcdb.utils.Coordinate;
//import alma.acs.tmcdb.Term;

/**
 * Used in cloning; transformer to 'pass through' (i.e. return the identical object reference)
 * any 'global' domain classes; in this case, the global classes are those
 * that are not associated with a configuration: LruType, AssemblyType,
 * PropertyType, and AssemblyRole.
 *
 * @author sharrington
 */
public class ConfigurationGlobalTransformer implements CustomBeanTransformerSpi
{
	protected BeanTransformerSpi defaultBeanTransformer;

	public ConfigurationGlobalTransformer(BeanTransformerSpi beanTransformer)
	{
		this.defaultBeanTransformer = beanTransformer;
	}

	@SuppressWarnings("unchecked")
	@Override
	public  boolean isTransformable(Object from, Class toClass, PropertyInfo propertyInfo) {
		if (toClass == LRUType.class ||
//				toClass == Term.class ||   TODO: Verify that eliminating these two (not in generated POJOs) here is OK
//				toClass == ArrayReference.class ||
                toClass == Coordinate.class ||
                toClass == AssemblyType.class ||
                toClass == AssemblyRole.class ||
                toClass == ComponentType.class ||
                toClass == Location.class ||
                toClass == Contact.class
				)
			return true;

		return false;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T transform(Object in, Class<T> toClass, PropertyInfo propertyInfo)
	{
		// Default behavior: global tables' rows are just copied
		T retVal = (T)in;
		return retVal;
	}
}
