package alma.tmcdb.cloning;

import java.util.Set;

import net.sf.beanlib.PropertyInfo;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.CustomBeanTransformerSpi;

import org.hibernate.collection.PersistentSet;

import alma.acs.tmcdb.HWConfiguration;
import alma.acs.tmcdb.BaseElement;
//import alma.acs.tmcdb.BaseElementType;

/**
 * Used in cloning; custom transformer to handle startup scenarios; specifically, reuses many of the 'global' 
 * (and/or other items that can be shared within a configuration) from the startup scenario that is being cloned,
 * rather than blindly cloning everything recursively.
 * 
 * @author sharrington
 */
public class BaseElementTransformer implements CustomBeanTransformerSpi
{
	private HWConfiguration configurationBeingCloned;
	private BeanTransformerSpi defaultBeanTransformer;

	public BaseElementTransformer(BeanTransformerSpi contextBeanTransformer, HWConfiguration configurationBeingCloned) 
	{
		this.defaultBeanTransformer = contextBeanTransformer;
		this.configurationBeingCloned = configurationBeingCloned;
	}

	@Override
	@SuppressWarnings("unchecked")
	public  boolean isTransformable(Object from, Class toClass, PropertyInfo propertyInfo) 
	{
		boolean retVal = false;

		if(null != from && BaseElement.class.isAssignableFrom(toClass))
		{
			BaseElement be = (BaseElement) from;
			// if the baseelement is from a *different* configuration, this transformer will handle it; otherwise not.
			if(!be.getHWConfiguration().getConfiguration().getConfigurationName().equals(configurationBeingCloned.getConfiguration().getConfigurationName()) || 
			  (null != be.getHWConfiguration().getConfigurationId() && null != configurationBeingCloned.getConfigurationId() 
			   && !be.getHWConfiguration().getConfigurationId().equals(configurationBeingCloned.getConfigurationId())) )
			{
				retVal = true;
			}
		} 
		
		return retVal;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T transform(Object in, Class<T> toClass, PropertyInfo propertyInfo)
	{
		// because the baseelement is from a different configuration (hence this transformer is handling it), 
		// we don't actually want to clone it, instead just returning it as-is.
		T retVal = (T)in;
		return retVal;
	}
}

