ALTER TABLE Antenna ADD (
    DelayBLLocked CHAR(1) NULL,
    DelayBLIncreaseVersion CHAR(1) NULL,
    DelayBLCurrentVersion NUMBER(10) NULL,
    DelayBLWho VARCHAR2(128) NULL,
    DelayBLChangeDesc VARCHAR2(1024) NULL
);

UPDATE Antenna SET DelayBLLocked = '0';
UPDATE Antenna SET DelayBLIncreaseVersion = '0';
UPDATE Antenna SET DelayBLCurrentVersion = 0;
UPDATE Antenna SET DelayBLWho = '';
UPDATE Antenna SET DelayBLChangeDesc = '';

ALTER TABLE HWConfiguration ADD (
    XPDelayBLLocked CHAR(1) NULL,
    XPDelayBLIncreaseVersion CHAR(1) NULL,
    XPDelayBLCurrentVersion NUMBER(10) NULL,
    XPDelayBLWho VARCHAR2(128) NULL,
    XPDelayBLChangeDesc VARCHAR2(1024) NULL
);

UPDATE HWConfiguration SET XPDelayBLLocked = '0';
UPDATE HWConfiguration SET XPDelayBLIncreaseVersion = '0';
UPDATE HWConfiguration SET XPDelayBLCurrentVersion = 0;
UPDATE HWConfiguration SET XPDelayBLWho = '';
UPDATE HWConfiguration SET XPDelayBLChangeDesc = '';

ALTER TABLE PointingModel ADD (
    Locked CHAR(1) NULL,
    IncreaseVersion CHAR(1) NULL,
    CurrentVersion NUMBER(10) NULL,
    Who VARCHAR2(128) NULL,
    ChangeDesc VARCHAR2(1024) NULL
);

UPDATE PointingModel SET Locked = '0';
UPDATE PointingModel SET IncreaseVersion = '0';
UPDATE PointingModel SET CurrentVersion = 0;
UPDATE PointingModel SET Who = '';
UPDATE PointingModel SET ChangeDesc = '';

ALTER TABLE FocusModel ADD (
    Locked CHAR(1) NULL,
    IncreaseVersion CHAR(1) NULL,
    CurrentVersion NUMBER(10) NULL,
    Who VARCHAR2 (128) NULL,
    ChangeDesc VARCHAR2(1024) NULL
);

UPDATE FocusModel SET Locked = '0';
UPDATE FocusModel SET IncreaseVersion = '0';
UPDATE FocusModel SET CurrentVersion = 0;
UPDATE FocusModel SET Who = '';
UPDATE FocusModel SET ChangeDesc = '';

ALTER TABLE Pad ADD (
    Locked CHAR(1) NULL,
    IncreaseVersion CHAR(1) NULL,
    CurrentVersion NUMBER(10) NULL,
    Who VARCHAR2 (128) NULL,
    ChangeDesc VARCHAR2(1024) NULL
);

UPDATE Pad SET Locked = '0';
UPDATE Pad SET IncreaseVersion = '0';
UPDATE Pad SET CurrentVersion = 0;
UPDATE Pad SET Who = '';
UPDATE Pad SET ChangeDesc = '';

CREATE TABLE BL_FEDelay (
    Version NUMBER(10) NOT NULL,
    ModTime NUMBER(19) NOT NULL,
    Operation CHAR(1) NOT NULL,
    Who VARCHAR2(128) NULL,
    ChangeDesc VARCHAR2(1024) NULL,
    FEDelayId NUMBER (10) NOT NULL,
    AntennaId NUMBER (10) NOT NULL,
    ReceiverBand VARCHAR2 (128) NOT NULL,
    Polarization VARCHAR2 (128) NOT NULL,
    SideBand VARCHAR2 (128) NOT NULL,
    Delay BINARY_DOUBLE NOT NULL,
    CONSTRAINT BL_FEDelayOp CHECK (Operation IN ('I', 'U', 'D')),
    CONSTRAINT BL_FEDelayKey PRIMARY KEY (Version, ModTime, Operation, FEDelayId)
);

CREATE TABLE BL_IFDelay (
    Version NUMBER(10) NOT NULL,
    ModTime NUMBER(19) NOT NULL,
    Operation CHAR(1) NOT NULL,
    Who VARCHAR2(128) NULL,
    ChangeDesc VARCHAR2(1024) NULL,
    IFDelayId NUMBER (10) NOT NULL,
    AntennaId NUMBER (10) NOT NULL,
    BaseBand VARCHAR2 (128) NOT NULL,
    Polarization VARCHAR2 (128) NOT NULL,
    IFSwitch VARCHAR2 (128) NOT NULL,
    Delay BINARY_DOUBLE NOT NULL,
    CONSTRAINT BL_IFDelayOp CHECK (Operation IN ('I', 'U', 'D')),
    CONSTRAINT BL_IFDelayKey PRIMARY KEY (Version, ModTime, Operation, IFDelayId)
);

CREATE TABLE BL_LODelay (
    Version NUMBER(10) NOT NULL,
    ModTime NUMBER(19) NOT NULL,
    Operation CHAR(1) NOT NULL,
    Who VARCHAR2(128) NULL,
    ChangeDesc VARCHAR2(1024) NULL,
    LODelayId NUMBER (10) NOT NULL,
    AntennaId NUMBER (10) NOT NULL,
    BaseBand VARCHAR2 (128) NOT NULL,
    Delay BINARY_DOUBLE NOT NULL,
    CONSTRAINT BL_LODelayOp CHECK (Operation IN ('I', 'U', 'D')),
    CONSTRAINT BL_LODelayKey PRIMARY KEY (Version, ModTime, Operation, LODelayId)
);

CREATE TABLE BL_XPDelay (
    Version NUMBER(10) NOT NULL,
    ModTime NUMBER(19) NOT NULL,
    Operation CHAR(1) NOT NULL,
    Who VARCHAR2(128) NULL,
    ChangeDesc VARCHAR2(1024) NULL,
    XPDelayId NUMBER (10) NOT NULL,
    ConfigurationId NUMBER (10) NOT NULL,
    ReceiverBand VARCHAR2 (128) NOT NULL,
    SideBand VARCHAR2 (128) NOT NULL,
    BaseBand VARCHAR2 (128) NOT NULL,
    Delay BINARY_DOUBLE NOT NULL,
    CONSTRAINT BL_XPDelayOp CHECK (Operation IN ('I', 'U', 'D')),
    CONSTRAINT BL_XPDelayKey PRIMARY KEY (Version, ModTime, Operation, XPDelayId)
);

CREATE TABLE BL_PointingModelCoeff (
    Version NUMBER (10) NOT NULL,
    ModTime NUMBER (19) NOT NULL,
    Operation CHAR (1) NOT NULL,
    Who VARCHAR2 (128) NULL,
    ChangeDesc VARCHAR2 (1024) NULL,
    PointingModelId NUMBER (10) NOT NULL,
    CoeffName VARCHAR2 (128) NOT NULL,
    CoeffValue BINARY_DOUBLE NOT NULL,
    CONSTRAINT BL_PointingModelCoeffOp CHECK (Operation IN ('I', 'U', 'D')),
    CONSTRAINT BL_PoiMCKey PRIMARY KEY (Version, ModTime, Operation, PointingModelId, CoeffName)
);

CREATE TABLE BL_PointingModelCoeffOffset (
    Version NUMBER (10) NOT NULL,
    ModTime NUMBER (19) NOT NULL,
    Operation CHAR (1) NOT NULL,
    Who VARCHAR2 (128) NULL,
    ChangeDesc VARCHAR2 (1024) NULL,
    PointingModelId NUMBER (10) NOT NULL,
    CoeffName VARCHAR2 (128) NOT NULL,
    ReceiverBand VARCHAR2 (128) NOT NULL,
    Offset BINARY_DOUBLE NOT NULL,
    CONSTRAINT BL_AntennaPMCoeffOffOp CHECK (Operation IN ('I', 'U', 'D')),
    CONSTRAINT BL_AntennaPMCoeffOffBand CHECK (ReceiverBand IN ('ALMA_RB_01', 'ALMA_RB_02', 'ALMA_RB_03', 'ALMA_RB_04', 'ALMA_RB_05', 'ALMA_RB_06', 'ALMA_RB_07', 'ALMA_RB_08', 'ALMA_RB_09', 'ALMA_RB_10')),
    CONSTRAINT BL_PoiMCOKey PRIMARY KEY (Version, ModTime, Operation, PointingModelId, CoeffName, ReceiverBand)
);


CREATE TABLE BL_FocusModelCoeff (
    Version NUMBER (10) NOT NULL,
    ModTime NUMBER (19) NOT NULL,
    Operation CHAR (1) NOT NULL,
    Who VARCHAR2 (128) NULL,
    ChangeDesc VARCHAR2 (1024) NULL,
    FocusModelId NUMBER (10) NOT NULL,
    CoeffName VARCHAR2 (128) NOT NULL,
    CoeffValue BINARY_DOUBLE NOT NULL,
    CONSTRAINT BL_FocusModelCoeffOp CHECK (Operation IN ('I', 'U', 'D')),
    CONSTRAINT BL_FocMCKey PRIMARY KEY (Version, ModTime, Operation, FocusModelId, CoeffName)
);


CREATE TABLE BL_FocusModelCoeffOffset (
    Version NUMBER (10) NOT NULL,
    ModTime NUMBER (19) NOT NULL,
    Operation CHAR (1) NOT NULL,
    Who VARCHAR2 (128) NULL,
    ChangeDesc VARCHAR2 (1024) NULL,
    FocusModelId NUMBER (10) NOT NULL,
    CoeffName VARCHAR2 (128) NOT NULL,
    ReceiverBand VARCHAR2 (128) NOT NULL,
    Offset BINARY_DOUBLE NOT NULL,
    CONSTRAINT BL_AntennaFMCoeffOffOp CHECK (Operation IN ('I', 'U', 'D')),
    CONSTRAINT BL_AntennaFMCoeffOffBand CHECK (ReceiverBand IN ('ALMA_RB_01', 'ALMA_RB_02', 'ALMA_RB_03', 'ALMA_RB_04', 'ALMA_RB_05', 'ALMA_RB_06', 'ALMA_RB_07', 'ALMA_RB_08', 'ALMA_RB_09', 'ALMA_RB_10')),
    CONSTRAINT BL_FocMCOKey PRIMARY KEY (Version, ModTime, Operation, FocusModelId, CoeffName, ReceiverBand)
);

CREATE TABLE BL_AntennaDelay (
    Version NUMBER (10) NOT NULL,
    ModTime NUMBER (19) NOT NULL,
    Operation CHAR (1) NOT NULL,
    Who VARCHAR2 (128) NULL,
    ChangeDesc VARCHAR2 (1024) NULL,
    BaseElementId NUMBER (10) NOT NULL,
    Delay BINARY_DOUBLE NOT NULL,
    CONSTRAINT BL_AntDelayKey PRIMARY KEY (Version, ModTime, Operation, BaseElementId)
);

CREATE TABLE BL_Pad (
    Version NUMBER (10) NOT NULL,
    ModTime NUMBER (19) NOT NULL,
    Operation CHAR (1) NOT NULL,
    Who VARCHAR2 (128) NULL,
    ChangeDesc VARCHAR2 (1024) NULL,
    BaseElementId NUMBER (10) NOT NULL,
    CommissionDate NUMBER (19) NOT NULL,
    XPosition BINARY_DOUBLE NOT NULL,
    YPosition BINARY_DOUBLE NOT NULL,
    ZPosition BINARY_DOUBLE NOT NULL,
    Delay BINARY_DOUBLE NOT NULL,
    CONSTRAINT BL_PadKey PRIMARY KEY (Version, ModTime, Operation, BaseElementId)
);
