package alma.tmcdb.access;

import junit.framework.TestCase;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import astri.TMCDB_IDL.AssemblyLocationIDL;
import astri.TMCDB_IDL.StartupTelescopeIDL;

public class TmcdbAccessorTest extends TestCase {

    private static Logger logger =
        LoggerFactory.getLogger(TmcdbAccessorTest.class);
    TmcdbHibernateAccessor tmcdb;
    
    public TmcdbAccessorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        tmcdb = new TmcdbHibernateAccessor();
    }

    protected void tearDown() throws Exception {
        tmcdb.clear();
        super.tearDown();
    }

    public void testGetStartupAntennasInfo() throws Exception {
    	StartupTelescopeIDL[] sai = tmcdb.getStartupTelescopesInfo();
    	logger.info("startup antenna length: " + sai.length);
    	for (StartupTelescopeIDL sa : sai) {
    		logger.info("antennaName: " + sa.telescopeName);
    		//logger.info("frontEndName: " + sa.frontEndName);
    		logger.info("padName: " + sa.padName);
    		logger.info("uiDisplayOrder: " + sa.uiDisplayOrder);
    		for (AssemblyLocationIDL aa : sa.telescopeAssembly) {
    			logger.info("\tassemblyRoleName: " + aa.assemblyRoleName);
    			logger.info("\tassemblyTypeName: " + aa.assemblyTypeName);
    			logger.info("\tbaseAddress: " + aa.baseAddress);
    			logger.info("\tchannelNumber: " + aa.channelNumber);
    			logger.info("\trca: " + aa.rca);
    		}
//    		for (AssemblyLocationIDL aa : sa.frontEndAssembly) {
//    			logger.info("\tassemblyRoleName: " + aa.assemblyRoleName);
//    			logger.info("\tassemblyTypeName: " + aa.assemblyTypeName);
//    			logger.info("\tbaseAddress: " + aa.baseAddress);
//    			logger.info("\tchannelNumber: " + aa.channelNumber);
//    			logger.info("\trca: " + aa.rca);
//    		}
    	}
    }
    
}
