/*******************************************************************************
 * ALMA - Atacama Large Millimiter Array
 * (c) Associated Universities Inc., 2010
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 * "@(#) $Id: TmcdbAntennaLOOffsetTest.cpp,v 1.2 2011/07/28 17:07:23 rhiriart Exp $"
 *
 */

#include <iostream>
#include <acsutil.h>
#include <maciSimpleClient.h>
#include <logging.h>
#include <TmcdbAntennaLOOffset.h>

using namespace maci;

void testTmcdbLOOffsetsWithAllAntennas(ContainerServices* container) {
    TmcdbAntennaLOOffset tmcdbLOOffsets(container);
    std::cout << "----------------------- ALL ANTENNAS ------------------------" << std::endl;
    std::cout << "----------------------- LO Offsets --------------------------" << std::endl;
    TmcdbAntennaLOOffset::loOffsetIndexMap_t map = tmcdbLOOffsets.getLOOffsets();
    for (TmcdbAntennaLOOffset::loOffsetIndexMap_t::iterator it = map.begin(); it != map.end(); ++it) {
            std::cout << it->first << " " << it->second << std::endl;
    }
}

void testTmcdbLOOffsetsWithFewAntennas(ContainerServices* container) {
    TmcdbAntennaLOOffset tmcdbLOOffsets(container);
    TmcdbAntennaLOOffset::antennaIDs_t antennaIds;
    antennaIds.push_back("DV01");
    std::cout << "----------------------- SELECTED ANTENNAS -------------------" << std::endl;
    std::cout << "----------------------- LO Offsets --------------------------" << std::endl;
    TmcdbAntennaLOOffset::loOffsetIndexMap_t map = tmcdbLOOffsets.getLOOffsets(antennaIds);
    for (TmcdbAntennaLOOffset::loOffsetIndexMap_t::iterator it = map.begin(); it != map.end(); ++it) {
            std::cout << it->first << " " << it->second << std::endl;
    }
}

int main(int argc, char** argv) {
    SimpleClient client;
    if (client.init(argc, argv) == 0) {
    	ACS_SHORT_LOG((LM_ERROR, "Cannot init client"));
    	return -1;
    }
    client.login();
    testTmcdbLOOffsetsWithAllAntennas(client.getContainerServices());
    testTmcdbLOOffsetsWithFewAntennas(client.getContainerServices());
    client.logout();
    return 0;
}

