/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * File TMCDBComponentImplCreator.java
 */
package alma.tmcdb.access.compimpl;

import java.util.logging.Logger;

import alma.TMCDB.AccessOperations;
import alma.TMCDB.AccessPOATie;
import alma.acs.component.ComponentLifecycle;
import alma.acs.container.ComponentHelper;
import alma.maciErrType.wrappers.AcsJComponentCreationEx;

public class TmcdbStandaloneComponentImplHelper extends ComponentHelper {

    public TmcdbStandaloneComponentImplHelper(Logger containerLogger) {
        super(containerLogger);
    }

    @Override
	protected ComponentLifecycle _createComponentImpl()
        throws AcsJComponentCreationEx {
        return new TmcdbStandaloneComponentImpl();
    }

    @Override
	protected Class _getPOATieClass() {
        return AccessPOATie.class;
    }

    @Override
	protected Class _getOperationsInterface() {
        return AccessOperations.class;
    }

}
