package alma.tmcdb.access;

import alma.TMCDB.ArrayReferenceLocation;
import alma.TMCDB.AssemblyConfigXMLData;
import alma.TMCDB.TelescopeFocusModel;
import alma.TMCDB.TelescopePointingModel;
import astri.TMCDB_IDL.TelescopeIDL;
import astri.TMCDB_IDL.PadIDL;
import astri.TMCDB_IDL.StartupTelescopeIDL;
import astri.TMCDB_IDL.StartupWeatherStationControllerIDL;
import alma.TmcdbErrType.wrappers.AcsJTmcdbErrorEx;
import alma.TmcdbErrType.wrappers.AcsJTmcdbNoSuchRowEx;
import alma.acs.component.ComponentLifecycleException;

public class TmcdbStandaloneMixedAccessor implements TmcdbAccessor {

    /** Main TMCDB Accessor, uses Hibernate to access the database */
    TmcdbAccessor tmcdb;

    /** The temporary XML TMCDB Accessor, taken from the simulation impl */
    TmcdbAccessor xmlTmcdb;
    
    public TmcdbStandaloneMixedAccessor() throws ComponentLifecycleException {
        try {
            this.tmcdb = new TmcdbStandaloneHibernateAccessor();
        } catch (Exception ex) {
            ex.printStackTrace();
            throw new ComponentLifecycleException(ex);
        }
        this.xmlTmcdb = new TmcdbXmlAccessor();
    }

    @Override
    public void clear() throws Exception {
        if (tmcdb != null) {
            try {
                tmcdb.clear();
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public TelescopeIDL getTelescopeInfo(String antennaName)
            throws AcsJTmcdbNoSuchRowEx {
        return tmcdb.getTelescopeInfo(antennaName);
    }

    @Override
    public ArrayReferenceLocation getArrayReferenceLocation() {
        return xmlTmcdb.getArrayReferenceLocation();
    }

    @Override
    public AssemblyConfigXMLData getAssemblyConfigData(String serialNumber)
            throws AcsJTmcdbNoSuchRowEx {
        return tmcdb.getAssemblyConfigData(serialNumber);
    }

    @Override
    public AssemblyConfigXMLData getComponentConfigData(String componentName) {
        return tmcdb.getComponentConfigData(componentName);
    }

    @Override
    public String getConfigurationName() {
        return tmcdb.getConfigurationName();
    }

    @Override
    public TelescopeFocusModel getCurrentTelescopeFocusModel(String antennaName)
            throws AcsJTmcdbErrorEx, AcsJTmcdbNoSuchRowEx {
        return xmlTmcdb.getCurrentTelescopeFocusModel(antennaName);
    }

    @Override
    public PadIDL getCurrentTelescopePadInfo(String antennaName)
            throws AcsJTmcdbNoSuchRowEx {
        return xmlTmcdb.getCurrentTelescopePadInfo(antennaName);
    }

    @Override
    public TelescopePointingModel getCurrentTelescopePointingModel(String antennaName)
            throws AcsJTmcdbErrorEx, AcsJTmcdbNoSuchRowEx {
        return xmlTmcdb.getCurrentTelescopePointingModel(antennaName);
    }

    @Override
    public StartupTelescopeIDL[] getStartupTelescopesInfo() {
        return tmcdb.getStartupTelescopesInfo();
    }

    @Override
    public StartupWeatherStationControllerIDL getStartupWeatherStationControllerInfo()
            throws AcsJTmcdbErrorEx {
        return xmlTmcdb.getStartupWeatherStationControllerInfo();
    }

    //@Override
    //public XPDelay[] getCrossPolarizationDelays() throws AcsJTmcdbErrorEx,
            //AcsJTmcdbNoSuchRowEx {
        //return null;
    //}

    @Override
    public String getTelescopeName() throws AcsJTmcdbErrorEx,
            AcsJTmcdbNoSuchRowEx {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void reportAssemblyOperational(String serialNumber,
            String componentName) {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void reportTelescopeOnline(String antennaName) {
        // TODO Auto-generated method stub
        
    }

	@Override
	public TelescopeIDL[] getTelescopes() throws AcsJTmcdbErrorEx, AcsJTmcdbNoSuchRowEx {
		// TODO Auto-generated method stub
		return null;
	}   
}
