/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * "@(#) $Id: TmcdbAccessor.java,v 1.9 2011/08/09 15:48:17 rhiriart Exp $"
 */
package alma.tmcdb.access;

import alma.TMCDB.ArrayReferenceLocation;
import alma.TMCDB.AssemblyConfigXMLData;
import alma.TMCDB.TelescopeFocusModel;
import alma.TMCDB.TelescopePointingModel;
import astri.TMCDB_IDL.TelescopeIDL;
import astri.TMCDB_IDL.PadIDL;
import astri.TMCDB_IDL.StartupTelescopeIDL;
import astri.TMCDB_IDL.StartupWeatherStationControllerIDL;
import alma.TmcdbErrType.wrappers.AcsJTmcdbErrorEx;
import alma.TmcdbErrType.wrappers.AcsJTmcdbNoSuchRowEx;

public interface TmcdbAccessor {

	public String getConfigurationName();

	public StartupTelescopeIDL[] getStartupTelescopesInfo();

	public TelescopeIDL getTelescopeInfo(String telescopeName)
			throws AcsJTmcdbNoSuchRowEx;

	public PadIDL getCurrentTelescopePadInfo(String telescopeName)
			throws AcsJTmcdbNoSuchRowEx;

	public AssemblyConfigXMLData getAssemblyConfigData(
			String serialNumber) throws AcsJTmcdbNoSuchRowEx;	
	
	public ArrayReferenceLocation getArrayReferenceLocation();

	public void clear() throws Exception;
	
	public AssemblyConfigXMLData getComponentConfigData(String componentName);
    
    public StartupWeatherStationControllerIDL getStartupWeatherStationControllerInfo()
    	throws AcsJTmcdbErrorEx;
    
    public TelescopePointingModel getCurrentTelescopePointingModel(String telescopeName)
    	throws AcsJTmcdbErrorEx, AcsJTmcdbNoSuchRowEx;
    
    public TelescopeFocusModel getCurrentTelescopeFocusModel(String telescopeName)
        throws AcsJTmcdbErrorEx, AcsJTmcdbNoSuchRowEx;
    
    public String getTelescopeName()
        throws AcsJTmcdbErrorEx, AcsJTmcdbNoSuchRowEx;
    
    public void reportTelescopeOnline(String telescopeName);
    
    public void reportAssemblyOperational(String serialNumber, String componentName);
    
	public TelescopeIDL[] getTelescopes() throws AcsJTmcdbErrorEx, AcsJTmcdbNoSuchRowEx;
}