/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File Telescope.java
 */
package alma.tmcdb.access;

import astri.TMCDB_IDL.TelescopeIDL;
import astri.physquan.runtime.asdm.types.ArrayTime;
import astri.physquan.runtime.asdm.types.Length;

/**

 * The Telescope table represents the general properties of an ALMA antenna.

 * The x-y-z position is the position from the pad position to the point of rotation of the antenna.  The x-y-z offset is the offset, if any, from that position to the point from which the feeds offsets are measured.

 * Included is the name of the software component that executes the antenna.

   * Key: BaseElementId

 *
 */
public class Telescope implements java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int BaseElementId;

    private String TelescopeName;

    // private boolean nullTelescopeName;

    private String TelescopeType;

    private Length DishDiameter;

    private ArrayTime CommissionDate;

    private Length XPosition;

    private Length YPosition;

    private Length ZPosition;

    private int ComponentId;

    /**
     * Default Constructor for Telescope.  Setter methods must be used to insert data.
     */
    public Telescope () {

        // nullTelescopeName = true;

    }

    /**
     * Create a Telescope by specifiying all data values.
     */
    public Telescope (

        int BaseElementId,

        String TelescopeName,

        String TelescopeType,

        Length DishDiameter,

        ArrayTime CommissionDate,

        Length XPosition,

        Length YPosition,

        Length ZPosition,

        Length XOffset,

        Length YOffset,

        Length ZOffset,

        int ComponentId

    ) {

		setBaseElementId(BaseElementId);

		setTelescopeName(TelescopeName);

		setTelescopeType(TelescopeType);

		setDishDiameter(DishDiameter);

		setCommissionDate(CommissionDate);

		setXPosition(XPosition);

		setYPosition(YPosition);

		setZPosition(ZPosition);

		setComponentId(ComponentId);

    }

    /**
     * Create a Telescope by specifiying data values as an array of strings.
     */
    public Telescope (String[] data) {
    	if (data.length != 12)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 12)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseElementId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullTelescopeName = true;
			// this.TelescopeName = null;

		} else {

			// nullTelescopeName = false;

			this.TelescopeName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.TelescopeType = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.DishDiameter = new Length(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CommissionDate = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.XPosition = new Length(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.YPosition = new Length(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ZPosition = new Length(data[i]);

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComponentId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "Telescope:" + newline;

        s += "\tBaseElementId: " + BaseElementId + newline;

    	// if (TelescopeName == null)
    	//	s += "\tTelescopeName: null" + newline;
    	// else

        s += "\tTelescopeName: " + TelescopeName + newline;

        s += "\tTelescopeType: " + TelescopeType + newline;

        s += "\tDishDiameter: " + DishDiameter + newline;

        s += "\tCommissionDate: " + CommissionDate.toFITS() + newline;

        s += "\tXPosition: " + XPosition + newline;

        s += "\tYPosition: " + YPosition + newline;

        s += "\tZPosition: " + ZPosition + newline;

        s += "\tComponentId: " + ComponentId + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "Telescope" + delimiter;  

        s += BaseElementId + delimiter;

        // if (nullTelescopeName)
        // 	s += delimiter;
        // else

        	// s += TelescopeName + delimiter;

        s += TelescopeType + delimiter;

        s += DishDiameter + delimiter;

		s += new String(CommissionDate.toFITS()) + delimiter;

        s += XPosition + delimiter;

        s += YPosition + delimiter;

        s += ZPosition + delimiter;

        s += ComponentId + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 12;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#Telescope" + delimiter  

        	+ "BaseElementId" + delimiter

        	+ "TelescopeName" + delimiter

        	+ "TelescopeType" + delimiter

        	+ "DishDiameter" + delimiter

        	+ "CommissionDate" + delimiter

        	+ "XPosition" + delimiter

        	+ "YPosition" + delimiter

        	+ "ZPosition" + delimiter

        	+ "XOffset" + delimiter

        	+ "YOffset" + delimiter

        	+ "ZOffset" + delimiter

        	+ "ComponentId" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof Telescope)) return false;
    	Telescope arg = (Telescope) obj;

		if (this.BaseElementId != arg.BaseElementId)
			return false;

		if (this.TelescopeName == null) {	// Two null strings are equal
			if (arg.TelescopeName == null)
				return true;
			else
				return false;
		}
		if (!this.TelescopeName.equals(arg.TelescopeName))
			return false; 

		if (this.TelescopeType == null) {	// Two null strings are equal
			if (arg.TelescopeType == null)
				return true;
			else
				return false;
		}
		if (!this.TelescopeType.equals(arg.TelescopeType))
			return false; 

		if (this.DishDiameter.get() != arg.DishDiameter.get())
			return false;

		if (this.CommissionDate.get() != arg.CommissionDate.get())
			return false;

		if (this.XPosition.get() != arg.XPosition.get())
			return false;

		if (this.YPosition.get() != arg.YPosition.get())
			return false;

		if (this.ZPosition.get() != arg.ZPosition.get())
			return false;

		if (this.ComponentId != arg.ComponentId)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public TelescopeIDL toIDL() {
    	TelescopeIDL x = new TelescopeIDL ();

		x.BaseElementId = this.BaseElementId;

		x.TelescopeName = this.TelescopeName;

        // x.nullTelescopeName = this.nullTelescopeName;

		x.TelescopeType = this.TelescopeType;

		x.DishDiameter = this.DishDiameter.toIDLLength();

		x.CommissionDate = this.CommissionDate.toIDLArrayTime();

		x.XPosition = this.XPosition.toIDLLength();

		x.YPosition = this.YPosition.toIDLLength();

		x.ZPosition = this.ZPosition.toIDLLength();

		x.ComponentId = this.ComponentId;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(TelescopeIDL x) {

		this.BaseElementId = x.BaseElementId;

		this.TelescopeName = x.TelescopeName;

        // this.nullTelescopeName = x.nullTelescopeName;

		this.TelescopeType = x.TelescopeType;

		this.DishDiameter = new Length(x.DishDiameter);

		this.CommissionDate = new ArrayTime(x.CommissionDate);

		this.XPosition = new Length(x.XPosition);

		this.YPosition = new Length(x.YPosition);

		this.ZPosition = new Length(x.ZPosition);

		this.ComponentId = x.ComponentId;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for Telescope.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for BaseElementId.
     */
    public int getBaseElementId () {
        return BaseElementId;
    }

    /**
     * Set BaseElementId to the specified value.
     */
    public void setBaseElementId(int BaseElementId) {

        this.BaseElementId = BaseElementId;

    }

    /**
     * Get the value for TelescopeName.
     */
    public String getTelescopeName () {
        return TelescopeName;
    }

    /**
     * Set TelescopeName to the specified value.
     */
    public void setTelescopeName(String TelescopeName) {

        // nullTelescopeName = false;

        this.TelescopeName = TelescopeName;

    }

    /*
     * Is the TelescopeName null?
     */
    // public boolean isTelescopeNameNull() {
    //	return nullTelescopeName;
    // }

    /*
     * Set the null indicator for TelescopeName
     */       
    // public void setTelescopeNameNull() {
    // 	nullTelescopeName = true;
    // }

    /**
     * Get the value for TelescopeType.
     */
    public String getTelescopeType () {
        return TelescopeType;
    }

    /**
     * Set TelescopeType to the specified value.
     */
    public void setTelescopeType(String TelescopeType) {

        this.TelescopeType = TelescopeType;

    }

    /**
     * Get the value for DishDiameter.
     */
    public Length getDishDiameter () {
        return DishDiameter;
    }

    /**
     * Set DishDiameter to the specified value.
     */
    public void setDishDiameter(Length DishDiameter) {

        this.DishDiameter = DishDiameter;

    }

    /**
     * Get the value for CommissionDate.
     */
    public ArrayTime getCommissionDate () {
        return CommissionDate;
    }

    /**
     * Set CommissionDate to the specified value.
     */
    public void setCommissionDate(ArrayTime CommissionDate) {

        this.CommissionDate = CommissionDate;

    }

    /**
     * Get the value for XPosition.
     */
    public Length getXPosition () {
        return XPosition;
    }

    /**
     * Set XPosition to the specified value.
     */
    public void setXPosition(Length XPosition) {

        this.XPosition = XPosition;

    }

    /**
     * Get the value for YPosition.
     */
    public Length getYPosition () {
        return YPosition;
    }

    /**
     * Set YPosition to the specified value.
     */
    public void setYPosition(Length YPosition) {

        this.YPosition = YPosition;

    }

    /**
     * Get the value for ZPosition.
     */
    public Length getZPosition () {
        return ZPosition;
    }

    /**
     * Set ZPosition to the specified value.
     */
    public void setZPosition(Length ZPosition) {

        this.ZPosition = ZPosition;

    }

    /**
     * Get the value for ComponentId.
     */
    public int getComponentId () {
        return ComponentId;
    }

    /**
     * Set ComponentId to the specified value.
     */
    public void setComponentId(int ComponentId) {

        this.ComponentId = ComponentId;

    }

}
