/**
 * Copyright European Southern Observatory 2009
 */

package alma.archive.database.helpers.wrappers;

import java.util.logging.Logger;

/**
 * An interface to the archiveConfig.properties file.
 * 
 * This class implements StateArchive-specific policies.
 *
 * @author rkurowsk, July 30, 2009
 * @version $Revision: 1.1 $
 */

// $Id: StateArchiveDbConfig.java,v 1.1 2010/05/03 09:17:47 rkurowsk Exp $

public class StateArchiveDbConfig extends AbstractDbConfig {
	
	private static final String STATE_ARCHIVE_CONNECTION 	= "archive.statearchive.connection";
	private static final String STATE_ARCHIVE_USER 			= "archive.statearchive.user";
	private static final String STATE_ARCHIVE_PASSWORD 		= "archive.statearchive.passwd";
	
    /**
     * Read DB configuration properties from a file.
     * 
     * @param logger
     * @throws DbConfigException
     * @throws IllegalArgumentException
     */
    public StateArchiveDbConfig(Logger logger )
            throws DbConfigException {
        super( logger );
    }
    
    /**
     * Extracts the connection, user & password params
     * @throws DbConfigException
     */
    @Override
    protected void extractParams()throws DbConfigException {
    	
    	configureConnectionUrl(extractParam(STATE_ARCHIVE_CONNECTION));
    	setUser(extractParam(STATE_ARCHIVE_USER));
        setPassword(extractParam(STATE_ARCHIVE_PASSWORD));
    }
}