CREATE TABLE `TMCDBVersion` (
	`DBName` VARCHAR (32) NOT NULL,
	`DBVersion` VARCHAR (32) NOT NULL,
	`DBDate` VARCHAR (32) NOT NULL,
	CONSTRAINT `TMCDBVersionKey` PRIMARY KEY (`DBName`)
) ENGINE=INNODB;
CREATE TABLE `AcsService` (
	`AcsServiceId` INTEGER PRIMARY KEY AUTO_INCREMENT,
	`ConfigurationId` INTEGER NOT NULL,
	`ServiceType` VARCHAR (12) NOT NULL,
	`ServiceInstanceName` VARCHAR (256) NULL,
	`ComputerId` INTEGER NOT NULL,
	CONSTRAINT `AcsServiceConfig` FOREIGN KEY (`ConfigurationId`) REFERENCES `Configuration` (`ConfigurationId`),
	CONSTRAINT `AcsServiceComputer` FOREIGN KEY (`ComputerId`) REFERENCES `Computer` (`NetworkDeviceId`),
	CONSTRAINT `AcsServiceServiceType` CHECK (`ServiceType` IN ('NAMING', 'IFR', 'CDB', 'NOTIFICATION', 'LOGGING', 'MANAGER', 'ALARM', 'LOGPROXY'))
) ENGINE=INNODB;
CREATE TABLE `MasterComponent` (
	`MasterComponentId` INTEGER PRIMARY KEY AUTO_INCREMENT,
	`ComponentId` INTEGER NOT NULL,
	`SubsystemName` VARCHAR (256) NOT NULL,
	CONSTRAINT `MComponentId` FOREIGN KEY (`ComponentId`) REFERENCES `Component` (`ComponentId`),
	CONSTRAINT `MasterCAltKey` UNIQUE (`ComponentId`)
) ENGINE=INNODB;
CREATE TABLE `NetworkDeviceSnmpConfig` (
	`NetworkDeviceId` INTEGER NOT NULL,
	`SnmpXmlClob` MEDIUMTEXT NOT NULL,
	`PropagateNA` BOOLEAN DEFAULT FALSE,
	`AcsAlarm` VARCHAR (16) DEFAULT 'NEVER',
	`SnmpCommunity` VARCHAR (256) NULL,
	`Netgroup` VARCHAR (256) NULL,
	CONSTRAINT `NetDevSnmpConfigNetDev` FOREIGN KEY (`NetworkDeviceId`) REFERENCES `NetworkDevice` (`NetworkDeviceId`),
	CONSTRAINT `NetDevSnmpConfigAcsAlarm` CHECK (`AcsAlarm` IN ('NEVER', 'ALWAYS', 'ALLOWSUPPRESSION')),
	CONSTRAINT `NetworDSCKey` PRIMARY KEY (`NetworkDeviceId`)
) ENGINE=INNODB;
CREATE TABLE `SnmpTrapSink` (
	`ConfigurationId` INTEGER NOT NULL,
	`TrapSinkComputerId` INTEGER NOT NULL,
	`TrapPort` INTEGER NOT NULL,
	`TrapSourcesNetworkMask` VARCHAR (256) NOT NULL,
	`SnmpTrapCommunity` VARCHAR (256) NULL,
	CONSTRAINT `SnmpTrapSinkConfig` FOREIGN KEY (`ConfigurationId`) REFERENCES `Configuration` (`ConfigurationId`),
	CONSTRAINT `SnmpTrapSinkComputer` FOREIGN KEY (`TrapSinkComputerId`) REFERENCES `Computer` (`NetworkDeviceId`),
	CONSTRAINT `SnmpTrapSinkKey` PRIMARY KEY (`ConfigurationId`)
) ENGINE=INNODB;
CREATE TABLE `NetworkPowerstrip` (
	`NetworkDeviceId` INTEGER,
	CONSTRAINT `NetworPKey` PRIMARY KEY (`NetworkDeviceId`),
	CONSTRAINT `NetworPNetworDFKey` FOREIGN KEY (`NetworkDeviceId`) REFERENCES `NetworkDevice` (`NetworkDeviceId`)
) ENGINE=INNODB;
CREATE TABLE `PowerstripSocket` (
	`PowerstripSocketId` INTEGER PRIMARY KEY AUTO_INCREMENT,
	`NetworkPowerstripId` INTEGER NOT NULL,
	`SocketNumber` INTEGER NOT NULL,
	`PoweredNetworkDeviceId` INTEGER NULL,
	`SocketName` VARCHAR (256) NULL,
	CONSTRAINT `PwrstripSockNetPowerstrip` FOREIGN KEY (`NetworkPowerstripId`) REFERENCES `NetworkPowerstrip` (`NetworkDeviceId`),
	CONSTRAINT `PwrstripSockNetDevice` FOREIGN KEY (`PoweredNetworkDeviceId`) REFERENCES `NetworkDevice` (`NetworkDeviceId`),
	CONSTRAINT `PowersSAltKey` UNIQUE (`NetworkPowerstripId`, `SocketNumber`)
) ENGINE=INNODB;
 



INSERT INTO TMCDBVersion VALUES ( 'TMCDB', '2.2.1', '2010-08-22T0000:00:00.0' );

COMMIT;
