package alma.acs.tmcdb;
// Generated Apr 24, 2021, 3:15:50 AM by Hibernate Tools 5.3.7.Final


import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

/**
 * PointingModel generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="`POINTINGMODEL`"
    , uniqueConstraints =  @UniqueConstraint(columnNames="`ANTENNAID`")
)
public class PointingModel extends alma.acs.tmcdb.translator.TmcdbObject implements alma.tmcdb.history.Identifiable,java.io.Serializable {


     protected Integer pointingModelId;
     protected Antenna antenna;
     protected Long observationTime;
     protected String execBlockUID;
     protected Integer scanNumber;
     protected String softwareVersion;
     protected String comments;
     protected Integer sourceNumber;
     protected String metrologyMode;
     protected String metrologyFlag;
     protected Double sourceDensity;
     protected Double pointingRMS;
     protected Boolean locked;
     protected Boolean increaseVersion;
     protected Integer currentVersion;
     protected String who;
     protected String changeDesc;
     private Set<PointingModelCoeff> pointingModelCoeffs = new HashSet<PointingModelCoeff>(0);

    public PointingModel() {
    }
   
    @javax.persistence.Transient
    public Long getId() {
    	return new Long(pointingModelId);
    }
    @Id @GeneratedValue(generator="alma_acs_tmcdb_PointingModel_PointingModelIdGenerator")
    @GenericGenerator(name="alma_acs_tmcdb_PointingModel_PointingModelIdGenerator", strategy="native",
       parameters = {@Parameter(name="sequence", value="PointiM_seq")}
	)

    
    @Column(name="`POINTINGMODELID`", unique=true, nullable=false)
    public Integer getPointingModelId() {
        return this.pointingModelId;
    }

    
    public void setPointingModelId(Integer pointingModelId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("pointingModelId", this.pointingModelId, this.pointingModelId = pointingModelId);
        else
            this.pointingModelId = pointingModelId;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="`ANTENNAID`", unique=true, nullable=false)
    public Antenna getAntenna() {
        return this.antenna;
    }

    
    public void setAntenna(Antenna antenna) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("antenna", this.antenna, this.antenna = antenna);
        else
            this.antenna = antenna;
    }


    
    @Column(name="`OBSERVATIONTIME`")
    public Long getObservationTime() {
        return this.observationTime;
    }

    
    public void setObservationTime(Long observationTime) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("observationTime", this.observationTime, this.observationTime = observationTime);
        else
            this.observationTime = observationTime;
    }


    
    @Column(name="`EXECBLOCKUID`", length=100)
    public String getExecBlockUID() {
        return this.execBlockUID;
    }

    
    public void setExecBlockUID(String execBlockUID) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("execBlockUID", this.execBlockUID, this.execBlockUID = execBlockUID);
        else
            this.execBlockUID = execBlockUID;
    }


    
    @Column(name="`SCANNUMBER`")
    public Integer getScanNumber() {
        return this.scanNumber;
    }

    
    public void setScanNumber(Integer scanNumber) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("scanNumber", this.scanNumber, this.scanNumber = scanNumber);
        else
            this.scanNumber = scanNumber;
    }


    
    @Column(name="`SOFTWAREVERSION`", length=100)
    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    
    public void setSoftwareVersion(String softwareVersion) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("softwareVersion", this.softwareVersion, this.softwareVersion = softwareVersion);
        else
            this.softwareVersion = softwareVersion;
    }


    
    @Column(name="`COMMENTS`", length=16777216)
    public String getComments() {
        return this.comments;
    }

    
    public void setComments(String comments) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("comments", this.comments, this.comments = comments);
        else
            this.comments = comments;
    }


    
    @Column(name="`SOURCENUMBER`")
    public Integer getSourceNumber() {
        return this.sourceNumber;
    }

    
    public void setSourceNumber(Integer sourceNumber) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("sourceNumber", this.sourceNumber, this.sourceNumber = sourceNumber);
        else
            this.sourceNumber = sourceNumber;
    }


    
    @Column(name="`METROLOGYMODE`", length=100)
    public String getMetrologyMode() {
        return this.metrologyMode;
    }

    
    public void setMetrologyMode(String metrologyMode) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("metrologyMode", this.metrologyMode, this.metrologyMode = metrologyMode);
        else
            this.metrologyMode = metrologyMode;
    }


    
    @Column(name="`METROLOGYFLAG`", length=100)
    public String getMetrologyFlag() {
        return this.metrologyFlag;
    }

    
    public void setMetrologyFlag(String metrologyFlag) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("metrologyFlag", this.metrologyFlag, this.metrologyFlag = metrologyFlag);
        else
            this.metrologyFlag = metrologyFlag;
    }


    
    @Column(name="`SOURCEDENSITY`", precision=64, scale=0)
    public Double getSourceDensity() {
        return this.sourceDensity;
    }

    
    public void setSourceDensity(Double sourceDensity) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("sourceDensity", this.sourceDensity, this.sourceDensity = sourceDensity);
        else
            this.sourceDensity = sourceDensity;
    }


    
    @Column(name="`POINTINGRMS`", precision=64, scale=0)
    public Double getPointingRMS() {
        return this.pointingRMS;
    }

    
    public void setPointingRMS(Double pointingRMS) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("pointingRMS", this.pointingRMS, this.pointingRMS = pointingRMS);
        else
            this.pointingRMS = pointingRMS;
    }


    
    @Column(name="`LOCKED`")
    public Boolean getLocked() {
        return this.locked;
    }

    
    public void setLocked(Boolean locked) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("locked", this.locked, this.locked = locked);
        else
            this.locked = locked;
    }


    
    @Column(name="`INCREASEVERSION`")
    public Boolean getIncreaseVersion() {
        return this.increaseVersion;
    }

    
    public void setIncreaseVersion(Boolean increaseVersion) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("increaseVersion", this.increaseVersion, this.increaseVersion = increaseVersion);
        else
            this.increaseVersion = increaseVersion;
    }


    
    @Column(name="`CURRENTVERSION`")
    public Integer getCurrentVersion() {
        return this.currentVersion;
    }

    
    public void setCurrentVersion(Integer currentVersion) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("currentVersion", this.currentVersion, this.currentVersion = currentVersion);
        else
            this.currentVersion = currentVersion;
    }


    
    @Column(name="`WHO`", length=128)
    public String getWho() {
        return this.who;
    }

    
    public void setWho(String who) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("who", this.who, this.who = who);
        else
            this.who = who;
    }


    
    @Column(name="`CHANGEDESC`", length=16777216)
    public String getChangeDesc() {
        return this.changeDesc;
    }

    
    public void setChangeDesc(String changeDesc) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("changeDesc", this.changeDesc, this.changeDesc = changeDesc);
        else
            this.changeDesc = changeDesc;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="pointingModel")
    @Cascade( {CascadeType.ALL, CascadeType.DELETE_ORPHAN} )
    public Set<PointingModelCoeff> getPointingModelCoeffs() {
        return this.pointingModelCoeffs;
    }

    
    public void setPointingModelCoeffs(Set<PointingModelCoeff> pointingModelCoeffs) {    
    	this.pointingModelCoeffs = pointingModelCoeffs;
    }

	public void addPointingModelCoeffs(Set<PointingModelCoeff> elements) {
		if( this.pointingModelCoeffs != null )
			for(Iterator<PointingModelCoeff> it = elements.iterator(); it.hasNext(); )
				addPointingModelCoeffToPointingModelCoeffs((PointingModelCoeff)it.next());
	}

	public void addPointingModelCoeffToPointingModelCoeffs(PointingModelCoeff element) {
		if( !this.pointingModelCoeffs.contains(element) ) {
			this.pointingModelCoeffs.add(element);
		}
	}



   public boolean equalsContent(Object other) {
         if ( (this == other ) ) return true;
		 if ( (other == null ) ) return false;
		 if ( !(other instanceof PointingModel) ) return false;
		 PointingModel castOther = ( PointingModel ) other;

		 return ( (this.getAntenna()==castOther.getAntenna()) || ( this.getAntenna()!=null && castOther.getAntenna()!=null && this.getAntenna().equals(castOther.getAntenna()) ) );
   }

   public int hashCodeContent() {
         int result = 17;

         
         result = 37 * result + ( getAntenna() == null ? 0 : this.getAntenna().hashCode() );
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         return result;
   }


}


