package alma.acs.tmcdb;
// Generated Apr 24, 2021, 3:15:50 AM by Hibernate Tools 5.3.7.Final


import alma.hibernate.util.StringEnumUserType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;

/**
 * BaseElement generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="`BASEELEMENT`"
    , uniqueConstraints =  @UniqueConstraint(columnNames={"`BASEELEMENTNAME`", "`BASETYPE`", "`CONFIGURATIONID`"})
)
@Inheritance(strategy=InheritanceType.JOINED)
@TypeDef(name="BEType", typeClass=StringEnumUserType.class,
   parameters={ @Parameter(name="enumClassName", value="alma.acs.tmcdb.BEType") })
public class BaseElement extends alma.acs.tmcdb.translator.TmcdbObject implements java.io.Serializable {


     protected Integer baseElementId;
     protected HWConfiguration HWConfiguration;
     protected BEType baseType;
     protected String baseElementName;
     private Set<BaseElementOnline> baseElementOnlines = new HashSet<BaseElementOnline>(0);
     private Set<BaseElementStartup> baseElementStartups = new HashSet<BaseElementStartup>(0);

    public BaseElement() {
    }
   
    @Id @GeneratedValue(generator="alma_acs_tmcdb_BaseElement_BaseElementIdGenerator")
    @GenericGenerator(name="alma_acs_tmcdb_BaseElement_BaseElementIdGenerator", strategy="native",
       parameters = {@Parameter(name="sequence", value="BaseElement_seq")}
	)

    
    @Column(name="`BASEELEMENTID`", unique=true, nullable=false)
    public Integer getBaseElementId() {
        return this.baseElementId;
    }

    
    public void setBaseElementId(Integer baseElementId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("baseElementId", this.baseElementId, this.baseElementId = baseElementId);
        else
            this.baseElementId = baseElementId;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="`CONFIGURATIONID`", nullable=false)
    public HWConfiguration getHWConfiguration() {
        return this.HWConfiguration;
    }

    
    public void setHWConfiguration(HWConfiguration HWConfiguration) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("HWConfiguration", this.HWConfiguration, this.HWConfiguration = HWConfiguration);
        else
            this.HWConfiguration = HWConfiguration;
    }


    
    @Column(name="`BASETYPE`", nullable=false, length=16777216)
	@Type(type="BEType")
    public BEType getBaseType() {
        return this.baseType;
    }

    
    public void setBaseType(BEType baseType) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("baseType", this.baseType, this.baseType = baseType);
        else
            this.baseType = baseType;
    }


    
    @Column(name="`BASEELEMENTNAME`", nullable=false, length=16777216)
    public String getBaseElementName() {
        return this.baseElementName;
    }

    
    public void setBaseElementName(String baseElementName) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("baseElementName", this.baseElementName, this.baseElementName = baseElementName);
        else
            this.baseElementName = baseElementName;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="baseElement")
    public Set<BaseElementOnline> getBaseElementOnlines() {
        return this.baseElementOnlines;
    }

    
    public void setBaseElementOnlines(Set<BaseElementOnline> baseElementOnlines) {    
    	this.baseElementOnlines = baseElementOnlines;
    }

	public void addBaseElementOnlines(Set<BaseElementOnline> elements) {
		if( this.baseElementOnlines != null )
			for(Iterator<BaseElementOnline> it = elements.iterator(); it.hasNext(); )
				addBaseElementOnlineToBaseElementOnlines((BaseElementOnline)it.next());
	}

	public void addBaseElementOnlineToBaseElementOnlines(BaseElementOnline element) {
		if( !this.baseElementOnlines.contains(element) ) {
			this.baseElementOnlines.add(element);
		}
	}


@OneToMany(fetch=FetchType.LAZY, mappedBy="baseElement")
    public Set<BaseElementStartup> getBaseElementStartups() {
        return this.baseElementStartups;
    }

    
    public void setBaseElementStartups(Set<BaseElementStartup> baseElementStartups) {    
    	this.baseElementStartups = baseElementStartups;
    }

	public void addBaseElementStartups(Set<BaseElementStartup> elements) {
		if( this.baseElementStartups != null )
			for(Iterator<BaseElementStartup> it = elements.iterator(); it.hasNext(); )
				addBaseElementStartupToBaseElementStartups((BaseElementStartup)it.next());
	}

	public void addBaseElementStartupToBaseElementStartups(BaseElementStartup element) {
		if( !this.baseElementStartups.contains(element) ) {
			this.baseElementStartups.add(element);
		}
	}



   public boolean equalsContent(Object other) {
         if ( (this == other ) ) return true;
		 if ( (other == null ) ) return false;
		 if ( !(other instanceof BaseElement) ) return false;
		 BaseElement castOther = ( BaseElement ) other;

		 return ( (this.getHWConfiguration()==castOther.getHWConfiguration()) || ( this.getHWConfiguration()!=null && castOther.getHWConfiguration()!=null && this.getHWConfiguration().equals(castOther.getHWConfiguration()) ) )
 && ( (this.getBaseType()==castOther.getBaseType()) || ( this.getBaseType()!=null && castOther.getBaseType()!=null && this.getBaseType().equals(castOther.getBaseType()) ) )
 && ( (this.getBaseElementName()==castOther.getBaseElementName()) || ( this.getBaseElementName()!=null && castOther.getBaseElementName()!=null && this.getBaseElementName().equals(castOther.getBaseElementName()) ) );
   }

   public int hashCodeContent() {
         int result = 17;

         
         result = 37 * result + ( getHWConfiguration() == null ? 0 : this.getHWConfiguration().hashCode() );
         result = 37 * result + ( getBaseType() == null ? 0 : this.getBaseType().hashCode() );
         result = 37 * result + ( getBaseElementName() == null ? 0 : this.getBaseElementName().hashCode() );
         
         
         return result;
   }


}


