package alma.acs.tmcdb;
// Generated Apr 24, 2021, 3:15:50 AM by Hibernate Tools 5.3.7.Final


import alma.hibernate.util.StringEnumUserType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;

/**
 * AssemblyType generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="`ASSEMBLYTYPE`"
)
@TypeDef(name="BEType", typeClass=StringEnumUserType.class,
   parameters={ @Parameter(name="enumClassName", value="alma.acs.tmcdb.BEType") })
public class AssemblyType extends alma.acs.tmcdb.translator.TmcdbObject implements java.io.Serializable {


     protected String assemblyTypeName;
     protected ComponentType componentType;
     protected LRUType LRUType;
     protected BEType baseElementType;
     protected String fullName;
     protected String description;
     protected String notes;
     protected String productionCode;
     protected String simulatedCode;
     private Set<DefaultComponent> defaultComponents = new HashSet<DefaultComponent>(0);
     private Set<Assembly> assemblies = new HashSet<Assembly>(0);
     private Set<HwSchemas> hwSchemases = new HashSet<HwSchemas>(0);
     private Set<AssemblyRole> assemblyRoles = new HashSet<AssemblyRole>(0);

    public AssemblyType() {
    }
   
    @Id 

    
    @Column(name="`ASSEMBLYTYPENAME`", unique=true, nullable=false, length=256)
    public String getAssemblyTypeName() {
        return this.assemblyTypeName;
    }

    
    public void setAssemblyTypeName(String assemblyTypeName) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("assemblyTypeName", this.assemblyTypeName, this.assemblyTypeName = assemblyTypeName);
        else
            this.assemblyTypeName = assemblyTypeName;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="`COMPONENTTYPEID`", nullable=false)
    public ComponentType getComponentType() {
        return this.componentType;
    }

    
    public void setComponentType(ComponentType componentType) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("componentType", this.componentType, this.componentType = componentType);
        else
            this.componentType = componentType;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="`LRUNAME`", nullable=false)
    public LRUType getLRUType() {
        return this.LRUType;
    }

    
    public void setLRUType(LRUType LRUType) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("LRUType", this.LRUType, this.LRUType = LRUType);
        else
            this.LRUType = LRUType;
    }


    
    @Column(name="`BASEELEMENTTYPE`", nullable=false, length=16777216)
	@Type(type="BEType")
    public BEType getBaseElementType() {
        return this.baseElementType;
    }

    
    public void setBaseElementType(BEType baseElementType) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("baseElementType", this.baseElementType, this.baseElementType = baseElementType);
        else
            this.baseElementType = baseElementType;
    }


    
    @Column(name="`FULLNAME`", nullable=false, length=256)
    public String getFullName() {
        return this.fullName;
    }

    
    public void setFullName(String fullName) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("fullName", this.fullName, this.fullName = fullName);
        else
            this.fullName = fullName;
    }


    
    @Column(name="`DESCRIPTION`", nullable=false, length=16777216)
    public String getDescription() {
        return this.description;
    }

    
    public void setDescription(String description) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("description", this.description, this.description = description);
        else
            this.description = description;
    }


    
    @Column(name="`NOTES`", length=16777216)
    public String getNotes() {
        return this.notes;
    }

    
    public void setNotes(String notes) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("notes", this.notes, this.notes = notes);
        else
            this.notes = notes;
    }


    
    @Column(name="`PRODUCTIONCODE`", nullable=false, length=256)
    public String getProductionCode() {
        return this.productionCode;
    }

    
    public void setProductionCode(String productionCode) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("productionCode", this.productionCode, this.productionCode = productionCode);
        else
            this.productionCode = productionCode;
    }


    
    @Column(name="`SIMULATEDCODE`", nullable=false, length=256)
    public String getSimulatedCode() {
        return this.simulatedCode;
    }

    
    public void setSimulatedCode(String simulatedCode) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("simulatedCode", this.simulatedCode, this.simulatedCode = simulatedCode);
        else
            this.simulatedCode = simulatedCode;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="assemblyType")
    public Set<DefaultComponent> getDefaultComponents() {
        return this.defaultComponents;
    }

    
    public void setDefaultComponents(Set<DefaultComponent> defaultComponents) {    
    	this.defaultComponents = defaultComponents;
    }

	public void addDefaultComponents(Set<DefaultComponent> elements) {
		if( this.defaultComponents != null )
			for(Iterator<DefaultComponent> it = elements.iterator(); it.hasNext(); )
				addDefaultComponentToDefaultComponents((DefaultComponent)it.next());
	}

	public void addDefaultComponentToDefaultComponents(DefaultComponent element) {
		if( !this.defaultComponents.contains(element) ) {
			this.defaultComponents.add(element);
		}
	}


@OneToMany(fetch=FetchType.LAZY, mappedBy="assemblyType")
    public Set<Assembly> getAssemblies() {
        return this.assemblies;
    }

    
    public void setAssemblies(Set<Assembly> assemblies) {    
    	this.assemblies = assemblies;
    }

	public void addAssemblies(Set<Assembly> elements) {
		if( this.assemblies != null )
			for(Iterator<Assembly> it = elements.iterator(); it.hasNext(); )
				addAssemblyToAssemblies((Assembly)it.next());
	}

	public void addAssemblyToAssemblies(Assembly element) {
		if( !this.assemblies.contains(element) ) {
			this.assemblies.add(element);
		}
	}


@OneToMany(fetch=FetchType.LAZY, mappedBy="assemblyType")
    public Set<HwSchemas> getHwSchemases() {
        return this.hwSchemases;
    }

    
    public void setHwSchemases(Set<HwSchemas> hwSchemases) {    
    	this.hwSchemases = hwSchemases;
    }

	public void addHwSchemases(Set<HwSchemas> elements) {
		if( this.hwSchemases != null )
			for(Iterator<HwSchemas> it = elements.iterator(); it.hasNext(); )
				addHwSchemasToHwSchemases((HwSchemas)it.next());
	}

	public void addHwSchemasToHwSchemases(HwSchemas element) {
		if( !this.hwSchemases.contains(element) ) {
			this.hwSchemases.add(element);
		}
	}


@OneToMany(fetch=FetchType.LAZY, mappedBy="assemblyType")
    @Cascade( {CascadeType.ALL, CascadeType.DELETE_ORPHAN} )
    public Set<AssemblyRole> getAssemblyRoles() {
        return this.assemblyRoles;
    }

    
    public void setAssemblyRoles(Set<AssemblyRole> assemblyRoles) {    
    	this.assemblyRoles = assemblyRoles;
    }

	public void addAssemblyRoles(Set<AssemblyRole> elements) {
		if( this.assemblyRoles != null )
			for(Iterator<AssemblyRole> it = elements.iterator(); it.hasNext(); )
				addAssemblyRoleToAssemblyRoles((AssemblyRole)it.next());
	}

	public void addAssemblyRoleToAssemblyRoles(AssemblyRole element) {
		if( !this.assemblyRoles.contains(element) ) {
			this.assemblyRoles.add(element);
		}
	}





}


