/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 */
package alma.archive.database.helpers;

public final class BuildString {
    private BuildString() {

    }

    /**
     * Helper function to concatenate strings using 
     * @java.lang.StringBuilder.
     * 
     * @param first
     * @param strings
     * @return first plus all in strings as @java.lang.String
     */
    public static String buildString(final String first, 
            final String... strings) {
        final StringBuilder sbuilder = new StringBuilder(first);
        if (strings != null) {
            for (String s : strings) {
                sbuilder.append(s);
            }
        }
        return sbuilder.toString();
    }
}
