/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.hibernate3;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Properties;
import net.sf.beanlib.hibernate3.DtoCentricHibernate3Template;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.impl.SessionImpl;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class Hibernate3SequenceGenerator {
    private Hibernate3SequenceGenerator() {
    }

    public static long nextval(String sequenceName, Session session) {
        Object target = session;
        if (Proxy.isProxyClass(session.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(session);
            if (invocationHandler instanceof DtoCentricHibernate3Template.DtoCentricCloseSuppressingInvocationHandler) {
                DtoCentricHibernate3Template.DtoCentricCloseSuppressingInvocationHandler dch = (DtoCentricHibernate3Template.DtoCentricCloseSuppressingInvocationHandler)invocationHandler;
                target = dch.getTarget();
            } else {
                String className;
                Class<?> invocationHandlerClass = invocationHandler.getClass();
                Class<?> invocationHandlerDeclaringClass = invocationHandlerClass.getDeclaringClass();
                if (invocationHandlerDeclaringClass == HibernateTemplate.class && (className = invocationHandlerClass.getName()).endsWith("CloseSuppressingInvocationHandler")) {
                    try {
                        Field f = invocationHandlerClass.getDeclaredField("target");
                        f.setAccessible(true);
                        target = f.get(invocationHandler);
                    }
                    catch (SecurityException e) {
                        throw new RuntimeException(e);
                    }
                    catch (NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        if (!(target instanceof SessionImpl)) {
            throw new IllegalStateException("Not yet know how to handle the given session!");
        }
        SessionImpl sessionImpl = (SessionImpl)target;
        IdentifierGenerator idGenerator = Hibernate3SequenceGenerator.createIdentifierGenerator(sequenceName, session);
        Serializable id = idGenerator.generate((SessionImplementor)sessionImpl, null);
        return (Long)id;
    }

    private static IdentifierGenerator createIdentifierGenerator(String sequenceName, Session session) {
        SessionFactory sessionFactory = session.getSessionFactory();
        if (!(sessionFactory instanceof SessionFactoryImpl)) {
            throw new IllegalStateException("Not yet know how to handle the session factory of the given session!");
        }
        SessionFactoryImpl sessionFactoryImpl = (SessionFactoryImpl)sessionFactory;
        Settings settings = sessionFactoryImpl.getSettings();
        Dialect dialect = settings.getDialect();
        Properties params = new Properties();
        params.setProperty("sequence", sequenceName);
        return IdentifierGeneratorFactory.create((String)"sequence", (Type)TypeFactory.heuristicType((String)"long"), (Properties)params, (Dialect)dialect);
    }
}

