/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.hibernate;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.sf.beanlib.CollectionPropertyName;
import net.sf.beanlib.hibernate.UnEnhancer;
import net.sf.beanlib.spi.PropertyFilter;
import net.sf.beanlib.utils.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernatePropertyFilter
implements PropertyFilter {
    private Set<Class<?>> entityBeanClassSet;
    private Set<? extends CollectionPropertyName<?>> collectionPropertyNameSet;
    private PropertyFilter vetoer;
    private final String applicationPackagePrefix;

    public HibernatePropertyFilter(Set<Class<?>> entityBeanClassSet, Set<? extends CollectionPropertyName<?>> collectionPropertyNameSet, PropertyFilter vetoer) {
        this.entityBeanClassSet = entityBeanClassSet;
        this.collectionPropertyNameSet = collectionPropertyNameSet;
        this.vetoer = vetoer;
        this.applicationPackagePrefix = "#";
    }

    public HibernatePropertyFilter(String applicationPackagePrefix, Set<Class<?>> entityBeanClassSet, Set<? extends CollectionPropertyName<?>> collectionPropertyNameSet, PropertyFilter vetoer) {
        this.entityBeanClassSet = entityBeanClassSet;
        this.collectionPropertyNameSet = collectionPropertyNameSet;
        this.vetoer = vetoer;
        this.applicationPackagePrefix = applicationPackagePrefix;
    }

    public HibernatePropertyFilter() {
        this.applicationPackagePrefix = "#";
    }

    public HibernatePropertyFilter(String applicationPackagePrefix) {
        this.applicationPackagePrefix = applicationPackagePrefix;
        this.entityBeanClassSet = Collections.emptySet();
    }

    public Set<Class<?>> getEntityBeanClassSet() {
        return this.entityBeanClassSet;
    }

    public HibernatePropertyFilter withEntityBeanClassSet(Set<Class<?>> entityBeanClassSet) {
        this.entityBeanClassSet = entityBeanClassSet;
        return this;
    }

    public Set<CollectionPropertyName<?>> getCollectionPropertyNameSet() {
        return this.collectionPropertyNameSet;
    }

    public HibernatePropertyFilter withCollectionPropertyNameSet(Set<? extends CollectionPropertyName<?>> collectionPropertyNameSet) {
        this.collectionPropertyNameSet = collectionPropertyNameSet;
        return this;
    }

    public PropertyFilter getVetoer() {
        return this.vetoer;
    }

    public HibernatePropertyFilter withVetoer(PropertyFilter vetoer) {
        this.vetoer = vetoer;
        return this;
    }

    public boolean propagate(String propertyName, Method readerMethod) {
        if (this.propagateImpl(propertyName, readerMethod)) {
            return this.vetoer == null ? true : this.vetoer.propagate(propertyName, readerMethod);
        }
        return false;
    }

    public boolean propagateImpl(String propertyName, Method readerMethod) {
        Class returnType = UnEnhancer.unenhanceClass(readerMethod.getReturnType());
        if (ClassUtils.immutable(returnType)) {
            return true;
        }
        if (returnType.isArray() && ClassUtils.immutable(returnType.getComponentType())) {
            return true;
        }
        if (this.entityBeanClassSet == null) {
            if (this.collectionPropertyNameSet == null) {
                return true;
            }
            return this.checkCollectionProperty(propertyName, readerMethod);
        }
        if (ClassUtils.isJavaPackage(returnType)) {
            if (this.collectionPropertyNameSet == null) {
                return true;
            }
            return this.checkCollectionProperty(propertyName, readerMethod);
        }
        Class superClass = returnType;
        do {
            if (!this.entityBeanClassSet.contains(superClass) && !this.isApplicationClass(superClass)) continue;
            return true;
        } while ((superClass = superClass.getSuperclass()) != null && superClass != Object.class);
        return false;
    }

    private boolean checkCollectionProperty(String propertyName, Method readerMethod) {
        Class returnType = UnEnhancer.unenhanceClass(readerMethod.getReturnType());
        if (Collection.class.isAssignableFrom(returnType) || Map.class.isAssignableFrom(returnType)) {
            CollectionPropertyName colPropName = new CollectionPropertyName(UnEnhancer.unenhanceClass(readerMethod.getDeclaringClass()), propertyName);
            return this.collectionPropertyNameSet.contains(colPropName);
        }
        return true;
    }

    public boolean isApplicationClass(Class<?> c) {
        return c != null && ClassUtils.fqcn(c).startsWith(this.applicationPackagePrefix);
    }
}

