/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.mssql;

import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsSqlDataTypeFactory
extends DefaultDataTypeFactory {
    private static final Logger logger = LoggerFactory.getLogger((Class)MsSqlDataTypeFactory.class);
    public static final int NCHAR = -8;
    public static final int NVARCHAR = -9;
    public static final int NTEXT = -10;

    public DataType createDataType(int sqlType, String sqlTypeName) throws DataTypeException {
        if (logger.isDebugEnabled()) {
            logger.debug("createDataType(sqlType={}, sqlTypeName={}) - start", (Object)String.valueOf(sqlType), (Object)sqlTypeName);
        }
        switch (sqlType) {
            case -8: {
                return DataType.CHAR;
            }
            case -9: {
                return DataType.VARCHAR;
            }
            case -10: {
                return DataType.LONGVARCHAR;
            }
        }
        return super.createDataType(sqlType, sqlTypeName);
    }
}

