/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger((Class)NumberDataType.class);
    private static final Number TRUE = new BigDecimal(1.0);
    private static final Number FALSE = new BigDecimal(0.0);

    NumberDataType(String name, int sqlType) {
        super(name, sqlType, BigDecimal.class, true);
    }

    public Object typeCast(Object value) throws TypeCastException {
        logger.debug("typeCast(value={}) - start", value);
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? (Number)TRUE : (Number)FALSE;
        }
        try {
            return new BigDecimal(value.toString());
        }
        catch (NumberFormatException e) {
            throw new TypeCastException(value, this, e);
        }
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        BigDecimal value;
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)new Integer(column), (Object)resultSet);
        }
        if ((value = resultSet.getBigDecimal(column)) == null || resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, new Integer(column), statement});
        }
        statement.setBigDecimal(column, (BigDecimal)this.typeCast(value));
    }
}

