/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.dataset.NoSuchTableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedTableNameMap {
    private static final Logger LOGGER = LoggerFactory.getLogger((Class)OrderedTableNameMap.class);
    private Map _tableMap = new HashMap();
    private List _tableNames = new ArrayList();
    private String _lastTableNameOverride;
    private boolean _caseSensitiveTableNames = false;

    public OrderedTableNameMap(boolean caseSensitiveTableNames) {
        this._caseSensitiveTableNames = caseSensitiveTableNames;
    }

    public Object get(String tableName) {
        String correctedCaseTableName = this.getTableName(tableName);
        return this._tableMap.get(correctedCaseTableName);
    }

    public String[] getTableNames() {
        return this._tableNames.toArray(new String[0]);
    }

    public boolean containsTable(String tableName) {
        String correctedCaseTableName = this.getTableName(tableName);
        return this._tableMap.containsKey(correctedCaseTableName);
    }

    public boolean isLastTable(String tableName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("isLastTable(tableName={}) - start", (Object)tableName);
        }
        if (this._tableNames.size() == 0) {
            return false;
        }
        String lastTable = this.getLastTableName();
        String lastTableCorrectCase = this.getTableName(lastTable);
        String inputTableCorrectCase = this.getTableName(tableName);
        return lastTableCorrectCase.equals(inputTableCorrectCase);
    }

    public String getLastTableName() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getLastTableName() - start");
        }
        if (this._lastTableNameOverride != null) {
            return this._lastTableNameOverride;
        }
        if (this._tableNames.size() > 0) {
            String lastTable = (String)this._tableNames.get(this._tableNames.size() - 1);
            return lastTable;
        }
        return null;
    }

    public void setLastTable(String tableName) throws NoSuchTableException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("setLastTable(name{}) - start", (Object)tableName);
        }
        if (!this.containsTable(tableName)) {
            throw new NoSuchTableException(tableName);
        }
        this._lastTableNameOverride = tableName;
    }

    public void add(String tableName, Object object) throws AmbiguousTableNameException {
        String tableNameCorrectedCase;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("add(tableName={}, object={}) - start", (Object)tableName, object);
        }
        if (this.containsTable(tableNameCorrectedCase = this.getTableName(tableName))) {
            throw new AmbiguousTableNameException(tableNameCorrectedCase);
        }
        this._tableMap.put(tableNameCorrectedCase, object);
        this._tableNames.add(tableName);
        this._lastTableNameOverride = null;
    }

    public Collection orderedValues() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("orderedValues() - start");
        }
        ArrayList<Object> orderedValues = new ArrayList<Object>(this._tableNames.size());
        Iterator iterator = this._tableNames.iterator();
        while (iterator.hasNext()) {
            String tableName = (String)iterator.next();
            Object object = this.get(tableName);
            orderedValues.add(object);
        }
        return orderedValues;
    }

    public void update(String tableName, Object object) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("update(tableName={}, object={}) - start", (Object)tableName, object);
        }
        if (!this.containsTable(tableName)) {
            throw new IllegalArgumentException("The table name '" + tableName + "' does not exist in the map");
        }
        tableName = this.getTableName(tableName);
        this._tableMap.put(tableName, object);
    }

    public String getTableName(String tableName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getTableName(tableName={}) - start", (Object)tableName);
        }
        String result = tableName;
        if (!this._caseSensitiveTableNames) {
            result = tableName.toUpperCase(Locale.ENGLISH);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getTableName(tableName={}) - end - result={}", (Object)tableName, (Object)result);
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("_tableNames=").append(this._tableNames);
        sb.append(", _tableMap=").append(this._tableMap);
        sb.append(", _caseSensitiveTableNames=").append(this._caseSensitiveTableNames);
        sb.append("]");
        return sb.toString();
    }
}

